package com.xebialabs.deployit.core.service.impl

import com.xebialabs.deployit.core.api.dto.settings.{ConfigurationDto, GeneralSettings}
import com.xebialabs.deployit.core.service.GeneralSettingsService
import com.xebialabs.deployit.repository.ConfigurationRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class GeneralSettingsServiceImpl(@Autowired configurationRepository: ConfigurationRepository) extends GeneralSettingsService {
  val HEADER_COLOR = "header_color"
  val INSTANCE_NAME = "instance_name"
  val LOGIN_SCREEN_MESSAGE = "login_screen_message"
  val LOGO_FILE = "logo_file"

  override def getGeneralSettings: GeneralSettings = {
    var headerColor: String = ""
    var instanceName: String = ""
    var loginScreenMessage: String =""
    var logoFile: String = ""
    val configurationList = configurationRepository.getConfigurationByKey()
    configurationList.foreach {
      case conf if conf.key.endsWith(HEADER_COLOR) => headerColor = conf.value
      case conf if conf.key.endsWith(INSTANCE_NAME) => instanceName = conf.value
      case conf if conf.key.endsWith(LOGIN_SCREEN_MESSAGE) => loginScreenMessage = conf.value
      case conf if conf.key.endsWith(LOGO_FILE) => logoFile = conf.value
    }
    GeneralSettings(headerColor, instanceName,loginScreenMessage, logoFile)
  }

  override def updateGeneralSettings(generalSettings: GeneralSettings): GeneralSettings = {
    val keysList: Set[String] = Set(HEADER_COLOR, INSTANCE_NAME,LOGIN_SCREEN_MESSAGE, LOGO_FILE)

    keysList.foreach(key => {
      var value: String = ""
      key match {
        case HEADER_COLOR => value = generalSettings.headerColor
        case INSTANCE_NAME => value = generalSettings.instanceName
        case LOGIN_SCREEN_MESSAGE => value = generalSettings.loginScreenMessage
        case LOGO_FILE => value = generalSettings.logoFile
      }
      configurationRepository.saveOrUpdate(ConfigurationDto(key.replace("_", " "), key, value))
    })
    getGeneralSettings
  }
}
