package com.xebialabs.deployit.core.api;

import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.api.execution.TaskWithSteps;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;
import java.util.stream.Stream;

@Path("/internal/reports")
@Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON})
public interface InternalReportProxy {
    @GET
    @Path("deployments")
    Report deploymentsForEnvironment(@QueryParam("parent") String environment, @QueryParam("date") Date date);

    @GET
    @Path("download/deployments")
    String downloadDeploymentsForEnvironment(@QueryParam("parent") String environment, @QueryParam("date") Date date);

    /**
     * Returns archived task by ID for viewing only.
     *
     * @deprecated
     *
     * @permission Available to everyone with report#view
     * @param taskId the ID of the task
     * @return the task.
     */
    @Deprecated
    @GET
    @Path("task/{taskid}")
    TaskWithSteps getTask(@PathParam("taskid") String taskId);

    @GET
    @Path("taskblock/{taskid}")
    TaskWithBlock getTaskWithBlock(@PathParam("taskid") String taskId);

    @GET
    @Path("taskblocksteps/{taskid}")
    TaskWithBlock getTaskWithBlockAndSteps(@PathParam("taskid") String taskId);

    @GET
    @Path("taskblock/{taskid}/block/{blockid}")
    StepBlockState getStepBlock(@PathParam("taskid") String taskId, @PathParam("blockid") String blockId);

    @POST
    @Path("tasks")
    @XmlElementWrapper(name = "report")
    Stream<ReportLine> getTaskReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @BeanParam Paging paging,
            @QueryParam("order") List<Ordering> order,
            @QueryParam("filterType") String filterType,
            @QueryParam("users") List<String> users,
            @QueryParam("states") List<String> states,
            @QueryParam("taskId") String taskId,
            @QueryParam("onlySuccessful") boolean onlySuccessful,
            @QueryParam("worker") String workerName,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/tasks")
    String downloadTaskReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @QueryParam("filterType") String filterType,
            @QueryParam("users") List<String> users,
            @QueryParam("states") List<String> states,
            @QueryParam("taskId") String taskId,
            @QueryParam("onlySuccessful") boolean onlySuccessful,
            @QueryParam("worker") String workerName,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("deploymentsstatebreakdown")
    Report deploymentsStateBreakdown(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/deploymentsstatebreakdown")
    String downloadDeploymentsStateBreakdown(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("deploymentskeyindicator")
    Report deploymentsKeyIndicator(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @QueryParam("filterType") String filterType,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/deploymentskeyindicator")
    String downloadDeploymentsKeyIndicator(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            List<ConfigurationItemId> configurationItemIds);

    @GET
    @Path("controltasks")
    @XmlElementWrapper(name = "report")
    Stream<ReportLine> getControlTasksReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            @BeanParam Paging paging,
            @QueryParam("order") List<Ordering> order);

    @GET
    @Path("download/controltasks")
    String downloadControlTasksReport(
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end);

    @POST
    @Path("deploymentskeyindicatoraggregatedbyfiltertype")
    Report deploymentsKeyIndicatorAggregatedByFilterType(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            List<ConfigurationItemId> configurationItemIds);

    @POST
    @Path("download/deploymentskeyindicatoraggregatedbyfiltertype")
    String downloadDeploymentsKeyIndicatorAggregatedByFilterType(
            @QueryParam("filterType") String filterType,
            @QueryParam("begin") Date begin,
            @QueryParam("end") Date end,
            List<ConfigurationItemId> configurationItemIds);

    @GET
    @Path("widgetdata")
    Report getDashboardWidgetReport(@QueryParam("widgetType") String widgetType, @QueryParam("begin") Date begin, @QueryParam("end") Date end);

    @GET
    @Path("environments")
    List<ConfigurationItemId> listEnvironments();

}
