package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * Provides placeholder information: whether it is encrypted; if not, and the user has read access, then provides its value; and
 * gives a reference to the dictionary that defines it.
 */
@XmlRootElement
@PublicApiRef
public class DictionaryWithValueView {
	private String value;
	private boolean encrypted;
	private DefinedPlaceholderReference dictionary;

	public DictionaryWithValueView() {
		// called internally
	}

	public DictionaryWithValueView(String value, boolean encrypted, DefinedPlaceholderReference dictionary) {
		this.value = value;
		this.encrypted = encrypted;
		this.dictionary = dictionary;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public boolean isEncrypted() {
		return encrypted;
	}

	public void setEncrypted(boolean encrypted) {
		this.encrypted = encrypted;
	}

	public DefinedPlaceholderReference getDictionary() {
		return dictionary;
	}

	public void setDictionary(DefinedPlaceholderReference dictionary) {
		this.dictionary = dictionary;
	}

	@Override
	public String toString() {
		return "DictionaryWithValueView{" +
				"value='" + value + '\'' +
				", encrypted='" + encrypted + '\'' +
				", dictionary=" + dictionary +
				'}';
	}
}
