package com.xebialabs.deployit.core.api.dto;

import akka.actor.AddressFromURIString;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class WorkerInfo {
    private int id;
    private String name;
    private String address;
    private boolean local;
    private String state;
    private int controlTasks;
    private int deploymentTasks;

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getAddress() {
        return address;
    }

    public boolean isLocal() {
        return local;
    }

    public String getState() {
        return state;
    }

    public int getControlTasks() {
        return controlTasks;
    }

    public int getDeploymentTasks() {
        return deploymentTasks;
    }

    public void setId(final int id) {
        this.id = id;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setAddress(final String address) {
        this.address = address;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setState(final String state) {
        this.state = state;
    }

    public void setControlTasks(final int controlTasks) {
        this.controlTasks = controlTasks;
    }

    public void setDeploymentTasks(final int deploymentTasks) {
        this.deploymentTasks = deploymentTasks;
    }

    public WorkerInfo() {}

    public WorkerInfo(final int id, final String name, final String address, final String state, final int deploymentTasks, final int controlTasks) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.local = AddressFromURIString.parse(address).hasLocalScope();
        this.state = state;
        this.deploymentTasks = deploymentTasks;
        this.controlTasks = controlTasks;
    }

    @Override
    public String toString() {
        return "WorkerInfo{" +
                "id=" + id +
                ", name='"  + name + '\'' +
                ", address='" + address + '\'' +
                ", local=" + local +
                ", state='" + state + '\'' +
                ", controlTasks=" + controlTasks +
                ", deploymentTasks=" + deploymentTasks +
                '}';
    }
}
