package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class ArchivedCompositeBlock extends ArchivedAbstractBlock implements CompositeBlockState {

    private List<BlockState> blocks = newArrayList();
    private boolean parallel;

    @Override
    public boolean isParallel() {
        return parallel;
    }

    @Override
    public List<BlockState> getBlocks() {
        return blocks;
    }

    public void setBlocks(final List<BlockState> blocks) {
        this.blocks = blocks;
    }

    public void setParallel(final boolean parallel) {
        this.parallel = parallel;
    }

    @Override
    public List<StepState> getStepList() {
        List<StepState> steps = newArrayList();
        for (BlockState block : blocks) {
            steps.addAll(((ArchivedAbstractBlock) block).getStepList());
        }
        return steps;
    }

    @Override
    public StepState getStep(BlockPath path) {
        int head = path.head();
        return ((ArchivedAbstractBlock) blocks.get(head - 1)).getStep(path.tail());
    }

    @Override
    public scala.Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply(this);
        }
        int head = path.head();
        return ((ArchivedAbstractBlock) blocks.get(head - 1)).getBlock(path.tail());
    }

    @Override
    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        ListBuffer<Tuple2<BlockPath, StepState>> swp = new ListBuffer<>();
        for (BlockState block : blocks) {
            swp.appendAll(((ArchivedAbstractBlock) block).getStepsWithPaths());
        }
        return swp.toSeq();
    }
}
