package com.xebialabs.deployit.task.archive;

import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.Block;
import com.xebialabs.deployit.engine.tasker.BlockPath;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class ArchivedStepBlock extends ArchivedAbstractBlock implements StepBlockState {

    private String satelliteId;

    private List<StepState> steps = newArrayList();

    @Override
    public int getCurrentStep() {
        return 0;
    }

    @Override
    public List<StepState> getSteps() {
        return steps;
    }

    @Override
    public String getSatelliteId() {
        return satelliteId;
    }

    public void setSatelliteId(String satelliteId) {
        this.satelliteId = satelliteId;
    }

    public void setSteps(final List<StepState> steps) {
        this.steps = steps;
    }

    @Override
    public List<StepState> getStepList() {
        return this.getSteps();
    }

    @Override
    public StepState getStep(BlockPath path) {
        if(steps.isEmpty())
            throw new IllegalStateException("No step information");

        if (path.isLeaf()) {
            return steps.get(path.head() - 1);
        } else {
            throw new IllegalArgumentException("Leaf block but not leaf path");
        }
    }

    @Override
    public scala.Option<Block> getBlock(BlockPath path) {
        if (path.isEmpty()) {
            return Option.apply(this);
        }
        throw new IllegalArgumentException("Leaf block but not leaf path");
    }

    @Override
    public Seq<Tuple2<BlockPath, StepState>> getStepsWithPaths() {
        BlockPath id = id();
        ListBuffer<Tuple2<BlockPath, StepState>> buffer = new ListBuffer<>();
        for (int i = 0; i < steps.size(); i++) {
            buffer.$plus$eq(new Tuple2<>(id.newSubPath(i + 1), steps.get(i)));
        }
        return buffer.toSeq();
    }
}
