package com.xebialabs.deployit.task.archive

import java.util

import org.joda.time.DateTime


trait DeploymentTaskAnalytics {

  def topNDeploymentsByState(begin: DateTime, end: DateTime, deploymentResult: DeploymentResult, topN: Int): util.Collection[TopNByStateReportLine]

  def topNLongestRunningDeployments(begin: DateTime, end: DateTime, topN: Int): util.Collection[TopNLongestRunningReportLine]

  def statusOverview(begin: DateTime, end: DateTime): util.Collection[StatusOverviewReportLine]

  def statusOverviewData(begin: DateTime, end: DateTime): util.Collection[StatusOverviewDataReportLine]

  def appEnvStatus(begin: DateTime, end: DateTime): util.Collection[AppEnvStatusReportLine]

  def throughput(begin: DateTime, end: DateTime): util.Collection[ThroughputReportLine]

  def averageDurationDeploymentsOverTime(begin: DateTime, end: DateTime): util.Collection[AverageDeploymentsDurationOverTimeReportLine]

  def successfulDeploymentDurations(begin: DateTime, end: DateTime): util.Collection[SuccessfulDeploymentDurationReportLine]
}

case class AverageDeploymentsDurationOverTimeReportLine(year: Int, monthno: Int, amount: Int, durationMillis: Long) {
  override def toString: String = s"Year [$year] Month [$monthno] deployments count [$amount] average duration [$durationMillis] millis]"
}

case class StatusOverviewReportLine(executionState: String, amount: Int) {
  override def toString: String = s"Application execution state [$executionState] amount [$amount]"
}

case class StatusOverviewDataReportLine(startDate: DateTime, endDate: DateTime, status: String, taskId: String) {
  override def toString: String = s"Deployment Start Date [$startDate] Deployment End Date [$endDate] " +
    s"Deployment Status [$status] Deployment Task Id [$taskId]"
}

case class AppEnvStatusReportLine(application: String, environment: String, amount: Int, executionState: String) {
  override def toString: String = s"Application [$application] environment [$environment] amount [$amount] executionState [$executionState]"
}

case class AppEnvPair(application: String, environment: String)

case class SuccessfulDeploymentDurationReportLine(amount: Int, count: Int, binStart: Option[Int], binEnd: Option[Int]) {
  override def toString: String = s"Distribution with [$amount]/[$count] deployments in a bin from [${binStart.orNull}] to [${binEnd.orNull}]"
}

case class ThroughputReportLine(year: Int, monthno: Int, amount: Int, executionState: String) {
  override def toString: String = s"Year [$year] month [$monthno] amount [$amount] executionState [$executionState]"
}

case class TopNByStateReportLine(application: String, environment: String, numOfDeployTasksInAState: Int, totalDeployTasks: Int) {
  override def toString: String = s"Application [$application] environment [$environment] numOfDeployTasksInAState [$numOfDeployTasksInAState] totalDeployTasks [$totalDeployTasks]"
}

case class TopNLongestRunningReportLine(durationMillis: Long, application: String, environment: String) {
  override def toString: String = s"Application [$application] environment [$environment] duration [$durationMillis] millis]"
}
