package com.xebialabs.deployit.taskexecution.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.booter.remote.xml.TaskConverterSelector;
import com.xebialabs.deployit.core.rest.xml.TaskSelectorWriter;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable = SerializableTask.class, tagName = "task")
public class TaskReaderWriter implements Converter {
    @Override
    public void marshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        new TaskSelectorWriter().marshal(source, writer, context);
    }

    @Override
    public Object unmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        return new TaskConverterSelector().unmarshal(reader, context);
    }

    @Override
    public boolean canConvert(final Class type) {
        return SerializableTask.class.isAssignableFrom(type);
    }
}
