package com.xebialabs.deployit.bootstrap

import ai.digital.deploy.task.serdes.TaskPekkoSerializer
import com.typesafe.config.Config
import com.xebialabs.deployit.tasksystem.TaskActorSystem
import org.apache.pekko.actor.ActorSystem
import org.springframework.context.ApplicationContext

import java.io.File

object TaskEnginePekkoBootstrapper {
  def init(config: Config, context: ApplicationContext): ActorSystem = {
    TaskActorSystem.setOverrideConfig(config)
    val system = TaskActorSystem.actorSystem
    val baseWorkDir = new File(context.getBean("baseWorkDir", classOf[String]))
    TaskPekkoSerializer.initExternalWorker(TaskPekkoSerializer.Conf(baseWorkDir), system)
    system
  }
}
