package com.xebialabs.deployit.tasksystem

import akka.actor.BootstrapSetup
import akka.actor.setup.{ActorSystemSetup, Setup}
import com.typesafe.config.Config

import scala.reflect.runtime.universe

trait AkkaSetupProvider {

  def apply(systemConfig: Config): Setup

}

object AkkaSetupProvider {

  val serializationAkkaSetupProviderProp = "deploy.task.serialization.akka-setup-provider"

  def apply(systemConfig: Config): ActorSystemSetup = {
    val actorConfig = if (systemConfig.hasPath("deploy.task.system"))
      systemConfig.getConfig("deploy.task.system").withFallback(systemConfig)
    else
      systemConfig

    val setup = ActorSystemSetup(BootstrapSetup(None, Some(ConfigLoading.loadConfig(actorConfig)), None))

    if (systemConfig.hasPath(serializationAkkaSetupProviderProp)) {
      val serializationAkkaSetupProvider: AkkaSetupProvider = companion[AkkaSetupProvider](
        systemConfig.getString(serializationAkkaSetupProviderProp)
      )
      setup.and(serializationAkkaSetupProvider(systemConfig))
    } else {
      setup
    }
  }

  private def companion[T](name: String)(implicit man: Manifest[T]): T = {
    val runtimeMirror = universe.runtimeMirror(getClass.getClassLoader)
    val module = runtimeMirror.staticModule(name)
    val obj = runtimeMirror.reflectModule(module)
    obj.instance.asInstanceOf[T]
  }
}
