/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.mockito.internal.configuration.plugins.PluginFinder;
import org.mockito.internal.util.collections.Iterables;
import org.mockito.plugins.PluginSwitch;

class PluginLoader {
    private final PluginSwitch pluginSwitch;
    private final Map<String, String> alias;

    public PluginLoader(PluginSwitch pluginSwitch) {
        this.pluginSwitch = pluginSwitch;
        this.alias = new HashMap<String, String>();
    }

    PluginLoader withAlias(String name, String type2) {
        this.alias.put(name, type2);
        return this;
    }

    <T> T loadPlugin(final Class<T> pluginType, String defaultPluginClassName) {
        try {
            T plugin = this.loadImpl(pluginType);
            if (plugin != null) {
                return plugin;
            }
            try {
                return pluginType.cast(Class.forName(defaultPluginClassName).newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException("Internal problem occurred, please report it. Mockito is unable to load the default implementation of class that is a part of Mockito distribution. Failed to load " + pluginType, e);
            }
        }
        catch (Throwable t) {
            return (T)Proxy.newProxyInstance(pluginType.getClassLoader(), new Class[]{pluginType}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new IllegalStateException("Could not initialize plugin: " + pluginType, t);
                }
            });
        }
    }

    private <T> T loadImpl(Class<T> service) {
        Enumeration<URL> resources;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            resources = loader.getResources("mockito-extensions/" + service.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load " + service, e);
        }
        try {
            String foundPluginClass = new PluginFinder(this.pluginSwitch).findPluginClass(Iterables.toIterable(resources));
            if (foundPluginClass != null) {
                String aliasType = this.alias.get(foundPluginClass);
                if (aliasType != null) {
                    foundPluginClass = aliasType;
                }
                Class<?> pluginClass = loader.loadClass(foundPluginClass);
                Object plugin = pluginClass.newInstance();
                return service.cast(plugin);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load " + service + " implementation declared in " + resources, e);
        }
    }
}

