/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Array;
import org.powermock.tests.utils.ArrayMerger;

public class ArrayMergerImpl
implements ArrayMerger {
    @Override
    public <T> T[] mergeArrays(Class<T> type2, T[] ... arraysToMerge) {
        if (arraysToMerge == null || arraysToMerge.length == 0) {
            return (Object[])Array.newInstance(type2, 0);
        }
        int size = 0;
        for (T[] array : arraysToMerge) {
            if (array == null) continue;
            size += array.length;
        }
        Object[] finalArray = (Object[])Array.newInstance(type2, size);
        int lastIndex = 0;
        for (T[] currentArray : arraysToMerge) {
            if (currentArray == null) continue;
            int currentArrayLength = currentArray.length;
            System.arraycopy(currentArray, 0, finalArray, lastIndex, currentArrayLength);
            lastIndex += currentArrayLength;
        }
        return finalArray;
    }
}

