/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterSignature {
    private final Class<?> type;
    private final Annotation[] annotations;

    public static ArrayList<ParameterSignature> signatures(Method method) {
        return ParameterSignature.signatures(method.getParameterTypes(), method.getParameterAnnotations());
    }

    public static List<ParameterSignature> signatures(Constructor<?> constructor) {
        return ParameterSignature.signatures(constructor.getParameterTypes(), constructor.getParameterAnnotations());
    }

    private static ArrayList<ParameterSignature> signatures(Class<?>[] parameterTypes, Annotation[][] parameterAnnotations) {
        ArrayList<ParameterSignature> sigs = new ArrayList<ParameterSignature>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            sigs.add(new ParameterSignature(parameterTypes[i], parameterAnnotations[i]));
        }
        return sigs;
    }

    private ParameterSignature(Class<?> type2, Annotation[] annotations) {
        this.type = type2;
        this.annotations = annotations;
    }

    public boolean canAcceptType(Class<?> candidate) {
        return this.type.isAssignableFrom(candidate);
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Annotation> getAnnotations() {
        return Arrays.asList(this.annotations);
    }

    public boolean canAcceptArrayType(Class<?> type2) {
        return type2.isArray() && this.canAcceptType(type2.getComponentType());
    }

    public boolean hasAnnotation(Class<? extends Annotation> type2) {
        return this.getAnnotation(type2) != null;
    }

    public <T extends Annotation> T findDeepAnnotation(Class<T> annotationType) {
        Annotation[] annotations2 = this.annotations;
        return this.findDeepAnnotation(annotations2, annotationType, 3);
    }

    private <T extends Annotation> T findDeepAnnotation(Annotation[] annotations, Class<T> annotationType, int depth) {
        if (depth == 0) {
            return null;
        }
        for (Annotation each : annotations) {
            if (annotationType.isInstance(each)) {
                return (T)((Annotation)annotationType.cast(each));
            }
            T candidate = this.findDeepAnnotation(each.annotationType().getAnnotations(), annotationType, depth - 1);
            if (candidate == null) continue;
            return (T)((Annotation)annotationType.cast(candidate));
        }
        return null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation each : this.getAnnotations()) {
            if (!annotationType.isInstance(each)) continue;
            return (T)((Annotation)annotationType.cast(each));
        }
        return null;
    }
}

