/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Longs;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractLongAssert<SELF extends AbstractLongAssert<SELF>>
extends AbstractComparableAssert<SELF, Long>
implements NumberAssert<SELF, Long> {
    @VisibleForTesting
    Longs longs = Longs.instance();

    public AbstractLongAssert(Long actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isEqualTo(long expected) {
        this.longs.assertEqual(this.info, this.actual, expected);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    public SELF isNotEqualTo(long other) {
        this.longs.assertNotEqual(this.info, this.actual, other);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isZero() {
        this.longs.assertIsZero(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.longs.assertIsNotZero(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.longs.assertIsOne(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.longs.assertIsPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.longs.assertIsNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.longs.assertIsNotNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.longs.assertIsNotPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isLessThan(long other) {
        this.longs.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(long other) {
        this.longs.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isGreaterThan(long other) {
        this.longs.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isGreaterThanOrEqualTo(long other) {
        this.longs.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isBetween(Long start, Long end) {
        this.longs.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(Long start, Long end) {
        this.longs.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(long expected, Offset<Long> offset) {
        this.longs.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(long expected, Offset<Long> offset) {
        this.longs.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Long expected, Offset<Long> offset) {
        this.longs.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Long expected, Offset<Long> offset) {
        this.longs.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(Long expected, Percentage percentage) {
        this.longs.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(Long expected, Percentage percentage) {
        this.longs.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(long expected, Percentage percentage) {
        this.longs.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(long expected, Percentage percentage) {
        this.longs.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super Long> customComparator) {
        super.usingComparator(customComparator);
        this.longs = new Longs(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractLongAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        super.usingDefaultComparator();
        this.longs = Longs.instance();
        return (SELF)((AbstractLongAssert)this.myself);
    }
}

