/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Throwables;

public class ShouldHaveRootCauseInstance
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveRootCauseInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        return Throwables.getRootCause(actual) == null ? new ShouldHaveRootCauseInstance(expectedCauseType) : new ShouldHaveRootCauseInstance(actual, expectedCauseType);
    }

    private ShouldHaveRootCauseInstance(Throwable actual, Class<? extends Throwable> expectedCauseType) {
        super("%nExpecting a throwable with root cause being an instance of:%n <%s>%nbut was an instance of:%n <%s>", expectedCauseType, Throwables.getRootCause(actual));
    }

    private ShouldHaveRootCauseInstance(Class<? extends Throwable> expectedCauseType) {
        super("%nExpecting a throwable with root cause being an instance of:%n <%s>%nbut current throwable has no cause.", expectedCauseType);
    }
}

