/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.verification;

import java.lang.reflect.Method;
import org.powermock.api.mockito.verification.PrivateMethodVerification;
import org.powermock.api.mockito.verification.WithOrWithoutVerifiedArguments;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.impl.ArrayMergerImpl;

public class DefaultPrivateMethodVerification
implements PrivateMethodVerification {
    private final Object objectToVerify;

    public DefaultPrivateMethodVerification(Object objectToVerify) {
        this.objectToVerify = objectToVerify;
    }

    @Override
    public void invoke(Object ... arguments) throws Exception {
        Whitebox.invokeMethod(this.objectToVerify, arguments);
    }

    @Override
    public void invoke(String methodToExecute, Object ... arguments) throws Exception {
        Whitebox.invokeMethod(this.objectToVerify, methodToExecute, arguments);
    }

    @Override
    public WithOrWithoutVerifiedArguments invoke(Method method) throws Exception {
        return new VerificationArguments(method);
    }

    private class VerificationArguments
    implements WithOrWithoutVerifiedArguments {
        private final Method method;

        public VerificationArguments(Method method) {
            if (method == null) {
                throw new IllegalArgumentException("method cannot be null");
            }
            this.method = method;
            this.method.setAccessible(true);
        }

        @Override
        public void withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
            if (additionalArguments == null || additionalArguments.length == 0) {
                this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, firstArgument);
            } else {
                Object[] arguments = new ArrayMergerImpl().mergeArrays(Object.class, {firstArgument}, additionalArguments);
                this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, arguments);
            }
        }

        @Override
        public void withNoArguments() throws Exception {
            this.method.invoke(DefaultPrivateMethodVerification.this.objectToVerify, new Object[0]);
        }
    }
}

