/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.reflection.GenericMaster;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.api.mockito.internal.configuration.PowerMockitoInjectingAnnotationEngine;
import org.powermock.core.classloader.annotations.Mock;
import org.powermock.core.spi.listener.AnnotationEnablerListener;
import org.powermock.core.spi.support.AbstractPowerMockTestListenerBase;
import org.powermock.reflect.Whitebox;

public class AnnotationEnabler
extends AbstractPowerMockTestListenerBase
implements AnnotationEnablerListener {
    @Override
    public void beforeTestMethod(Object testInstance, Method method, Object[] arguments) throws Exception {
        this.standardInject(testInstance);
        this.injectSpiesAndInjectToSetters(testInstance);
        this.injectCaptor(testInstance);
    }

    private void injectSpiesAndInjectToSetters(Object testInstance) {
        new PowerMockitoInjectingAnnotationEngine().process(testInstance.getClass(), testInstance);
    }

    private void injectCaptor(Object testInstance) throws Exception {
        Set<Field> fieldsAnnotatedWithCaptor = Whitebox.getFieldsAnnotatedWith(testInstance, Captor.class, new Class[0]);
        for (Field field2 : fieldsAnnotatedWithCaptor) {
            Object captor = this.processAnnotationOn(field2.getAnnotation(Captor.class), field2);
            field2.set(testInstance, captor);
        }
    }

    private void standardInject(Object testInstance) throws IllegalAccessException {
        Set<Field> fields = Whitebox.getFieldsAnnotatedWith(testInstance, this.getMockAnnotations());
        for (Field field2 : fields) {
            Mock annotation;
            String[] value;
            if (field2.get(testInstance) != null) continue;
            Class<?> type2 = field2.getType();
            if (field2.isAnnotationPresent(Mock.class) && ((value = (annotation = field2.getAnnotation(Mock.class)).value()).length != 1 || !"".equals(value[0]))) {
                System.err.println("PowerMockito deprecation: Use PowerMockito.spy(..) for partial mocking instead. A standard mock will be created instead.");
            }
            if (field2.isAnnotationPresent(org.mockito.Mock.class)) {
                String name;
                Class<?>[] extraInterfaces;
                org.mockito.Mock mockAnnotation = field2.getAnnotation(org.mockito.Mock.class);
                MockSettings mockSettings = Mockito.withSettings();
                Answers answers = mockAnnotation.answer();
                if (answers != null) {
                    mockSettings.defaultAnswer(answers.get());
                }
                if ((extraInterfaces = mockAnnotation.extraInterfaces()) != null && extraInterfaces.length > 0) {
                    mockSettings.extraInterfaces(extraInterfaces);
                }
                if ((name = mockAnnotation.name()) != null && name.length() > 0) {
                    mockSettings.name(name);
                }
                field2.set(testInstance, PowerMockito.mock(type2, mockSettings));
                continue;
            }
            field2.set(testInstance, PowerMockito.mock(type2));
        }
    }

    @Override
    public Class<? extends Annotation>[] getMockAnnotations() {
        return new Class[]{org.mockito.Mock.class, org.mockito.Mock.class, Mock.class};
    }

    private Object processAnnotationOn(Captor annotation, Field field2) {
        Class<?> type2 = field2.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(type2)) {
            throw new MockitoException("@Captor field must be of the type ArgumentCaptor.\nField: '" + field2.getName() + "' has wrong type\nFor info how to use @Captor annotations see examples in javadoc for MockitoAnnotations class.");
        }
        Class<?> cls = new GenericMaster().getGenericType(field2);
        return ArgumentCaptor.forClass(cls);
    }
}

