/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.service.keyvaluestorage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyValueStorageService {
    private static final String DATA_SOURCE_STATUS_FOLDER = "dataSourceStatus";
    private static final String DATA_SOURCE_PROBE_RESULT_KEY = "dataSourceProbeResult";
    private static final String WEBHOOK_API_KEY_KEY = "webhookApiKey";
    private static final String DATA_KEY = "data";
    private static final String CREDENTIALS_KEY = "credentials";
    private static final String PLUGIN_CREDENTIALS_KEY = "pluginCredentials";
    private static final String DEDUPE_METADATA_KEY = "dedupeMetadata";
    private static final String MANIFEST_KEY = "manifest";
    private static final String FIELDS_OBJECT_KEY = "fields";
    private static final Logger logger = LoggerFactory.getLogger(KeyValueStorageService.class);
    private final ObjectMapper objectMapper;

    public KeyValueStorageService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public abstract Optional<String> get(String var1);

    public abstract Optional<ReadableByteChannel> getAsReadableByteChannel(String var1);

    public Iterable<KeyAndValue<String, String>> mget(Collection<String> keys) {
        return () -> keys.stream().map(key -> new KeyAndValue<String, Object>((String)key, this.get((String)key).orElse(null))).filter(kv -> kv.getValue() != null).iterator();
    }

    public <T> void put(String key, T value) {
        this.putJson(key, this.convertAnythingToJson(value));
    }

    public <T> void mput(Map<String, T> values) {
        this.mputJson(values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convertAnythingToJson(e.getValue()))));
    }

    private <T> String convertAnythingToJson(T value) {
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void putJson(String var1, String var2);

    public abstract Optional<WritableByteChannel> getWriter(String var1);

    public void mputJson(Map<String, String> jsons) {
        for (Map.Entry<String, String> entry : jsons.entrySet()) {
            this.putJson(entry.getKey(), entry.getValue());
        }
    }

    public abstract Iterable<String> list(String var1);

    public abstract Iterable<String> list(String var1, long var2);

    public abstract void delete(String var1);

    public <T> Function<String, Optional<T>> getAsFactory(Class<T> clazz) {
        return key -> this.getAs((String)key, clazz);
    }

    public <T> Optional<T> getAs(String key, Class<T> clazz) {
        Optional<String> json = this.get(key);
        if (!json.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.convertTo(json.get(), clazz));
    }

    public <T> T convertTo(String json, Class<T> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return (T)json;
        }
        try {
            return this.objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Iterable<KeyAndValue<String, T>> mgetAs(Collection<String> keys, Class<T> clazz) {
        return () -> StreamSupport.stream(this.mget(keys).spliterator(), false).map(kv -> new KeyAndValue(kv.getKey(), this.convertTo((String)kv.getValue(), clazz))).iterator();
    }

    @Deprecated
    public String makeDataSourceStatusKey(String tenantId, DataSourceTypeEnum type2, String dataSourceId) {
        return this.makeDataSourceStatusKey(tenantId, type2.name(), dataSourceId);
    }

    public String makeDataSourceStatusKey(String tenantId, String pluginId, String dataSourceId) {
        return tenantId + "/" + DATA_SOURCE_STATUS_FOLDER + "/" + pluginId + "/" + dataSourceId;
    }

    @Deprecated
    public String makeDataSourceProbeResultKey(String tenantId, DataSourceTypeEnum type2, String dataSourceId, long probeId) {
        return this.makeDataSourceProbeResultKey(tenantId, type2.name(), dataSourceId, probeId);
    }

    public String makeDataSourceProbeResultKey(String tenantId, String pluginId, String dataSourceId, long probeId) {
        return tenantId + "/" + DATA_SOURCE_PROBE_RESULT_KEY + "/" + pluginId + "/" + dataSourceId + "/" + probeId;
    }

    public String makeWebhookApiKeyKey(String tenantId, String pluginId, String dataSourceId) {
        return tenantId + "/" + WEBHOOK_API_KEY_KEY + "/" + pluginId + "/" + dataSourceId;
    }

    public String makePartialDataKey(String tenantId, DataSourceTypeEnum dataSourceType) {
        return tenantId + "/" + DATA_KEY + "/" + dataSourceType.name();
    }

    public String makePartialDataKey(String tenantId, DataSourceTypeEnum dataSourceType, String dataSourceId) {
        return tenantId + "/" + DATA_KEY + "/" + dataSourceType.name() + "/" + dataSourceId;
    }

    public String makePartialDataKey(String tenantId, DataSourceTypeEnum unifiedModelType, String pluginId, String dataSourceId) {
        return tenantId + "/" + DATA_KEY + "/" + unifiedModelType.name() + "/" + pluginId + "/" + dataSourceId;
    }

    @Deprecated
    public String makeDataKey(String tenantId, DataSourceTypeEnum dataSourceType, String dataSourceId, String artefactId) {
        return this.makePartialDataKey(tenantId, dataSourceType) + "/" + dataSourceId + "/" + artefactId;
    }

    public String makeDataKey(String tenantId, DataSourceTypeEnum dataSourceType, String pluginId, String dataSourceId, String artefactId) {
        System.out.println(tenantId + " " + (Object)((Object)dataSourceType) + " " + pluginId + " " + dataSourceId + "  " + artefactId);
        return this.makePartialDataKey(tenantId, dataSourceType) + "/" + pluginId + "/" + dataSourceId + "/" + artefactId;
    }

    @Deprecated
    public String makePrefixForCredentialsKey(String tenantId) {
        return tenantId + "/" + CREDENTIALS_KEY + "/";
    }

    public String makePrefixForPluginCredentialsKey(String tenantId, String pluginId) {
        return tenantId + "/" + PLUGIN_CREDENTIALS_KEY + "/" + pluginId + "/";
    }

    @Deprecated
    public String makeCredentialsKey(String tenantId, DataSourceTypeEnum dataSourceType, String dataSourceId) {
        return this.makePrefixForCredentialsKey(tenantId) + dataSourceType.name() + "/" + dataSourceId;
    }

    public String makePluginCredentialsKey(String tenantId, String pluginId, String dataSourceId) {
        return this.makePrefixForPluginCredentialsKey(tenantId, pluginId) + dataSourceId;
    }

    public String makePluginManifestKey(String tenantId, String pluginId) {
        return this.makePrefixForPluginManifest(tenantId) + pluginId;
    }

    public String makePrefixForPluginManifest(String tenantId) {
        return tenantId + "/" + MANIFEST_KEY + "/";
    }

    public String makeFieldsObjectKey(String tenantId, String pluginId, String dataSourceId) {
        return tenantId + "/" + DATA_KEY + "/" + DataSourceTypeEnum.FIELDS.toString() + "/" + pluginId + "/" + dataSourceId + "/" + FIELDS_OBJECT_KEY;
    }

    public UnifiedModelCoords getCoordsFromPluginManifestPath(String key) {
        String[] pc = key.split("/", 4);
        if (pc.length != 3) {
            throw new IllegalArgumentException("[" + key + "] does not seem to be a plugin manifest key");
        }
        return new UnifiedModelCoords(pc[0], null, pc[2], null, null, null);
    }

    public UnifiedModelCoords getCoordsFromPluginCredentialsPath(String key) {
        String[] pc = key.split("/", 5);
        if (pc.length != 4) {
            throw new IllegalArgumentException("[" + key + "] does not seem to be a plugin credentials key");
        }
        return new UnifiedModelCoords(pc[0], null, pc[2], pc[3], null, null);
    }

    public Coords getOldCoordsFromCredentialsPath(String key) {
        String[] pc = key.split("/", 4);
        return new OldCoords(pc[0], DataSourceTypeEnum.valueOf(pc[2]), pc[3], null, key);
    }

    @Deprecated
    public String makeDedupeMetadataKey(String tenantId, DataSourceTypeEnum dataSourceType, String dataSourceId, String artefactId) {
        return tenantId + "/" + DEDUPE_METADATA_KEY + "/" + dataSourceType.name() + "/" + dataSourceId + "/" + artefactId;
    }

    public String makeDedupeMetadataKey(String tenantId, DataSourceTypeEnum dataSourceType, String pluginId, String dataSourceId, String artefactId) {
        return tenantId + "/" + DEDUPE_METADATA_KEY + "/" + dataSourceType.name() + "/" + pluginId + "/" + dataSourceId + "/" + artefactId;
    }

    public Coords getCoords(String key) {
        try {
            DataSourceTypeEnum dataType = DataSourceTypeEnum.valueOf(key.split("/", 4)[2]);
            String[] pc = key.split("/", 6);
            if (pc.length < 6) {
                throw new RuntimeException("Invalid key [" + key + "]");
            }
            return new UnifiedModelCoords(pc[0], dataType, pc[3], pc[4], pc[5], key);
        }
        catch (IllegalArgumentException e) {
            String[] pc = key.split("/", 5);
            if (pc.length < 5) {
                throw new RuntimeException("Invalid key [" + key + "]");
            }
            return new OldCoords(pc[0], DataSourceTypeEnum.valueOf(pc[2]), pc[3], pc[4], key);
        }
    }

    public <T> Iterable<T> mgetAndProcessAsync(final Iterator<String> keys, Function<String, T> processor) {
        int threads = 32;
        final ReentrantLock reentrantLock = new ReentrantLock();
        return () -> {
            if (!keys.hasNext()) {
                return Collections.emptyList().iterator();
            }
            final ExecutorService executorService = Executors.newFixedThreadPool(threads);
            final ExecutorCompletionService svc = new ExecutorCompletionService(executorService);
            final AtomicInteger busy = new AtomicInteger(0);
            final Consumer<String> submit = key -> {
                logger.debug("submitting [{}]", key);
                svc.submit(() -> processor.apply((String)key));
            };
            for (int i = 0; i < threads && keys.hasNext(); ++i) {
                busy.incrementAndGet();
                submit.accept((String)keys.next());
            }
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return busy.get() > 0;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object result = svc.take().get();
                        KeyValueStorageService.this.submitKeyOrShutdown(reentrantLock, keys, submit, busy, executorService);
                        return result;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        };
    }

    public Iterable<KeyAndValue<String, Optional<String>>> mgetAsyncLowMemory(final Iterator<String> keys) {
        int threads = 2;
        int bufferSize = 32768;
        final ReentrantLock reentrantLock = new ReentrantLock();
        return () -> {
            if (!keys.hasNext()) {
                return Collections.emptyList().iterator();
            }
            final ExecutorService executorService = Executors.newFixedThreadPool(threads);
            final ExecutorCompletionService svc = new ExecutorCompletionService(executorService);
            final AtomicInteger busy = new AtomicInteger(0);
            final Consumer<String> submit = key -> {
                logger.debug("submitting [{}]", key);
                svc.submit(() -> {
                    Optional<ReadableByteChannel> channel = this.getAsReadableByteChannel((String)key);
                    logger.debug("got [{}]", key);
                    return new GetResult((String)key, channel.orElse(null), bufferSize);
                });
            };
            for (int i = 0; i < threads && keys.hasNext(); ++i) {
                busy.incrementAndGet();
                submit.accept((String)keys.next());
            }
            return new Iterator<KeyAndValue<String, Optional<String>>>(){

                @Override
                public boolean hasNext() {
                    return busy.get() > 0;
                }

                @Override
                public KeyAndValue<String, Optional<String>> next() {
                    GetResult getResult;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        getResult = (GetResult)svc.take().get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                    logger.debug("took, going to read [{}]", (Object)getResult.key);
                    String value = getResult.readTillEof();
                    logger.debug("read [{}]", (Object)getResult.key);
                    KeyValueStorageService.this.submitKeyOrShutdown(reentrantLock, keys, submit, busy, executorService);
                    return new KeyAndValue<String, Optional<String>>(getResult.key, value == null ? Optional.empty() : Optional.of(value));
                }
            };
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitKeyOrShutdown(ReentrantLock reentrantLock, Iterator<String> keys, Consumer<String> submit, AtomicInteger busy, ExecutorService executorService) {
        try {
            reentrantLock.lock();
            if (keys.hasNext()) {
                submit.accept(keys.next());
            } else if (busy.decrementAndGet() == 0) {
                executorService.shutdown();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public abstract Map<String, String> getValues();

    public static class GetResult {
        private final String key;
        private final ReadableByteChannel channel;
        private final Reader reader;
        private final CharBuffer charBuffer;
        private boolean readDone;

        GetResult(String key, ReadableByteChannel channel, int bufferSize) {
            this.charBuffer = CharBuffer.allocate(bufferSize);
            this.key = key;
            this.channel = channel;
            logger.debug("Creating new Reader for [{}]", (Object)key);
            Reader reader = this.reader = channel == null ? null : Channels.newReader(channel, "UTF8");
            if (this.reader != null) {
                this.readFirst();
            }
        }

        public String getKey() {
            return this.key;
        }

        private void readFirst() {
            try {
                while (this.charBuffer.hasRemaining()) {
                    if (-1 != this.reader.read(this.charBuffer)) continue;
                    this.readDone = true;
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String readTillEof() {
            if (this.reader == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int alreadyRead = this.charBuffer.position();
            if (alreadyRead > 0) {
                this.charBuffer.rewind();
                sb.append(this.charBuffer, 0, alreadyRead);
            }
            try {
                if (!this.readDone) {
                    int read;
                    while (-1 != (read = this.reader.read(this.charBuffer))) {
                        if (read <= 0) continue;
                        this.charBuffer.rewind();
                        sb.append(this.charBuffer, 0, read);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    logger.debug("Closing Channel & Reader for [{}]", (Object)this.key);
                    this.reader.close();
                    this.channel.close();
                }
                catch (IOException ee) {
                    logger.error("IOException when closing channel: [{}]", ee);
                }
            }
            return sb.toString();
        }

        public ReadableByteChannel getChannel() {
            return this.channel;
        }
    }

    public static class UnifiedModelCoords
    extends Coords {
        private final DataSourceTypeEnum unifiedModelType;
        private final String pluginId;

        public UnifiedModelCoords(String tenantId, DataSourceTypeEnum unifiedModelType, String pluginId, String dataSourceId, String artefactId, String keyValueStorageKey) {
            super(tenantId, dataSourceId, artefactId, keyValueStorageKey);
            this.unifiedModelType = unifiedModelType;
            this.pluginId = pluginId;
        }

        public DataSourceTypeEnum getUnifiedModelType() {
            return this.unifiedModelType;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnifiedModelCoords that = (UnifiedModelCoords)o;
            return this.unifiedModelType == that.unifiedModelType && Objects.equals(this.pluginId, that.pluginId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.unifiedModelType, this.pluginId});
        }

        @Override
        public String toString() {
            return "UnifiedModelCoords{unifiedModelType=" + (Object)((Object)this.unifiedModelType) + ", pluginId='" + this.pluginId + '\'' + ", " + super.toString() + '}';
        }
    }

    public static class OldCoords
    extends Coords {
        private final DataSourceTypeEnum dataSourceType;

        public OldCoords(String tenantId, DataSourceTypeEnum dataSourceType, String dataSourceId, String artefactId, String keyValueStorageKey) {
            super(tenantId, dataSourceId, artefactId, keyValueStorageKey);
            this.dataSourceType = dataSourceType;
        }

        public DataSourceTypeEnum getDataSourceType() {
            return this.dataSourceType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OldCoords oldCoords = (OldCoords)o;
            return this.dataSourceType == oldCoords.dataSourceType;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.dataSourceType});
        }

        @Override
        public String toString() {
            return "OldCoords{dataSourceType=" + (Object)((Object)this.dataSourceType) + ", " + super.toString() + '}';
        }
    }

    public static abstract class Coords
    implements Serializable {
        private final String tenantId;
        private final String dataSourceId;
        private final String artefactId;
        private final String keyValueStorageKey;

        public Coords(String tenantId, String dataSourceId, String artefactId, String keyValueStorageKey) {
            this.tenantId = tenantId;
            this.dataSourceId = dataSourceId;
            this.artefactId = artefactId;
            this.keyValueStorageKey = keyValueStorageKey;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getArtefactId() {
            return this.artefactId;
        }

        public String getKeyValueStorageKey() {
            return this.keyValueStorageKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Coords coords = (Coords)o;
            return Objects.equals(this.tenantId, coords.tenantId) && Objects.equals(this.dataSourceId, coords.dataSourceId) && Objects.equals(this.artefactId, coords.artefactId) && Objects.equals(this.keyValueStorageKey, coords.keyValueStorageKey);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.dataSourceId, this.artefactId, this.keyValueStorageKey);
        }

        public String toString() {
            return "Coords{tenantId='" + this.tenantId + '\'' + ", dataSourceId='" + this.dataSourceId + '\'' + ", artefactId='" + this.artefactId + '\'' + ", keyValueStorageKey='" + this.keyValueStorageKey + '\'' + '}';
        }

        public String getDataSourceId() {
            return this.dataSourceId;
        }
    }

    public static class KeyAndValue<K, V>
    implements Serializable {
        private K key;
        private V value;

        public KeyAndValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public KeyAndValue setKey(K key) {
            this.key = key;
            return this;
        }

        public V getValue() {
            return this.value;
        }

        public KeyAndValue setValue(V value) {
            this.value = value;
            return this;
        }
    }
}

