/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.reflection.FieldSetter;

public class IndependentAnnotationEngine
implements org.mockito.plugins.AnnotationEngine,
AnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public IndependentAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new MockAnnotationProcessor());
        this.registerAnnotationProcessor(Captor.class, new CaptorAnnotationProcessor());
    }

    private Object createMockFor(Annotation annotation, Field field2) {
        return this.forAnnotation(annotation).process(annotation, field2);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A annotation) {
        if (this.annotationProcessorMap.containsKey(annotation.annotationType())) {
            return this.annotationProcessorMap.get(annotation.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            @Override
            public Object process(A annotation, Field field2) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(annotationClass, fieldAnnotationProcessor);
    }

    @Override
    public void process(Class<?> clazz, Object testInstance) {
        Field[] fields;
        for (Field field2 : fields = clazz.getDeclaredFields()) {
            boolean alreadyAssigned = false;
            for (Annotation annotation : field2.getAnnotations()) {
                Object mock = this.createMockFor(annotation, field2);
                if (mock == null) continue;
                this.throwIfAlreadyAssigned(field2, alreadyAssigned);
                alreadyAssigned = true;
                try {
                    FieldSetter.setField(testInstance, field2, mock);
                }
                catch (Exception e) {
                    throw new MockitoException("Problems setting field " + field2.getName() + " annotated with " + annotation, e);
                }
            }
        }
    }

    void throwIfAlreadyAssigned(Field field2, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            throw Reporter.moreThanOneAnnotationNotAllowed(field2.getName());
        }
    }
}

