/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldReader;
import org.mockito.internal.util.reflection.FieldSetter;

public class SpyOnInjectedFieldsHandler
extends MockInjectionStrategy {
    @Override
    protected boolean processInjection(Field field2, Object fieldOwner, Set<Object> mockCandidates) {
        FieldReader fieldReader = new FieldReader(fieldOwner, field2);
        if (!fieldReader.isNull() && field2.isAnnotationPresent(Spy.class)) {
            try {
                Object instance = fieldReader.read();
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                } else {
                    Object mock = Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field2.getName()));
                    FieldSetter.setField(fieldOwner, field2, mock);
                }
            }
            catch (Exception e) {
                throw new MockitoException("Problems initiating spied field " + field2.getName(), e);
            }
        }
        return false;
    }
}

