/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.AccessibilityChanger;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldReader;
import org.mockito.internal.util.reflection.FieldSetter;

public class FieldInitializer {
    private final Object fieldOwner;
    private final Field field;
    private final ConstructorInstantiator instantiator;

    public FieldInitializer(Object fieldOwner, Field field2) {
        this(fieldOwner, field2, new NoArgConstructorInstantiator(fieldOwner, field2));
    }

    public FieldInitializer(Object fieldOwner, Field field2, ConstructorArgumentResolver argResolver) {
        this(fieldOwner, field2, new ParameterizedConstructorInstantiator(fieldOwner, field2, argResolver));
    }

    private FieldInitializer(Object fieldOwner, Field field2, ConstructorInstantiator instantiator) {
        if (new FieldReader(fieldOwner, field2).isNull()) {
            this.checkNotLocal(field2);
            this.checkNotInner(field2);
            this.checkNotInterface(field2);
            this.checkNotEnum(field2);
            this.checkNotAbstract(field2);
        }
        this.fieldOwner = fieldOwner;
        this.field = field2;
        this.instantiator = instantiator;
    }

    public FieldInitializationReport initialize() {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(this.field);
        try {
            FieldInitializationReport fieldInitializationReport = this.acquireFieldInstance();
            return fieldInitializationReport;
        }
        catch (IllegalAccessException e) {
            throw new MockitoException("Problems initializing field '" + this.field.getName() + "' of type '" + this.field.getType().getSimpleName() + "'", e);
        }
        finally {
            changer.safelyDisableAccess(this.field);
        }
    }

    private void checkNotLocal(Field field2) {
        if (field2.getType().isLocalClass()) {
            throw new MockitoException("the type '" + field2.getType().getSimpleName() + "' is a local class.");
        }
    }

    private void checkNotInner(Field field2) {
        Class<?> type2 = field2.getType();
        if (type2.isMemberClass() && !Modifier.isStatic(type2.getModifiers())) {
            throw new MockitoException("the type '" + type2.getSimpleName() + "' is an inner non static class.");
        }
    }

    private void checkNotInterface(Field field2) {
        if (field2.getType().isInterface()) {
            throw new MockitoException("the type '" + field2.getType().getSimpleName() + "' is an interface.");
        }
    }

    private void checkNotAbstract(Field field2) {
        if (Modifier.isAbstract(field2.getType().getModifiers())) {
            throw new MockitoException("the type '" + field2.getType().getSimpleName() + "' is an abstract class.");
        }
    }

    private void checkNotEnum(Field field2) {
        if (field2.getType().isEnum()) {
            throw new MockitoException("the type '" + field2.getType().getSimpleName() + "' is an enum.");
        }
    }

    private FieldInitializationReport acquireFieldInstance() throws IllegalAccessException {
        Object fieldInstance = this.field.get(this.fieldOwner);
        if (fieldInstance != null) {
            return new FieldInitializationReport(fieldInstance, false, false);
        }
        return this.instantiator.instantiate();
    }

    static class ParameterizedConstructorInstantiator
    implements ConstructorInstantiator {
        private final Object testClass;
        private final Field field;
        private final ConstructorArgumentResolver argResolver;
        private final Comparator<Constructor<?>> byParameterNumber = new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> constructorA, Constructor<?> constructorB) {
                int argLengths = constructorB.getParameterTypes().length - constructorA.getParameterTypes().length;
                if (argLengths == 0) {
                    int constructorAMockableParamsSize = this.countMockableParams(constructorA);
                    int constructorBMockableParamsSize = this.countMockableParams(constructorB);
                    return constructorBMockableParamsSize - constructorAMockableParamsSize;
                }
                return argLengths;
            }

            private int countMockableParams(Constructor<?> constructor) {
                int constructorMockableParamsSize = 0;
                for (Class<?> aClass : constructor.getParameterTypes()) {
                    if (!MockUtil.typeMockabilityOf(aClass).mockable()) continue;
                    ++constructorMockableParamsSize;
                }
                return constructorMockableParamsSize;
            }
        };

        ParameterizedConstructorInstantiator(Object testClass, Field field2, ConstructorArgumentResolver argumentResolver) {
            this.testClass = testClass;
            this.field = field2;
            this.argResolver = argumentResolver;
        }

        @Override
        public FieldInitializationReport instantiate() {
            AccessibilityChanger changer = new AccessibilityChanger();
            Constructor<?> constructor = null;
            try {
                constructor = this.biggestConstructor(this.field.getType());
                changer.enableAccess(constructor);
                Object[] args = this.argResolver.resolveTypeInstances(constructor.getParameterTypes());
                Object newFieldInstance = constructor.newInstance(args);
                FieldSetter.setField(this.testClass, this.field, newFieldInstance);
                FieldInitializationReport fieldInitializationReport = new FieldInitializationReport(this.field.get(this.testClass), false, true);
                return fieldInitializationReport;
            }
            catch (IllegalArgumentException e) {
                throw new MockitoException("internal error : argResolver provided incorrect types for constructor " + constructor + " of type " + this.field.getType().getSimpleName(), e);
            }
            catch (InvocationTargetException e) {
                throw new MockitoException("the constructor of type '" + this.field.getType().getSimpleName() + "' has raised an exception (see the stack trace for cause): " + e.getTargetException().toString(), e);
            }
            catch (InstantiationException e) {
                throw new MockitoException("InstantiationException (see the stack trace for cause): " + e.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("IllegalAccessException (see the stack trace for cause): " + e.toString(), e);
            }
            finally {
                if (constructor != null) {
                    changer.safelyDisableAccess(constructor);
                }
            }
        }

        private void checkParameterized(Constructor<?> constructor, Field field2) {
            if (constructor.getParameterTypes().length == 0) {
                throw new MockitoException("the field " + field2.getName() + " of type " + field2.getType() + " has no parameterized constructor");
            }
        }

        private Constructor<?> biggestConstructor(Class<?> clazz) {
            List<Constructor<?>> constructors = Arrays.asList(clazz.getDeclaredConstructors());
            Collections.sort(constructors, this.byParameterNumber);
            Constructor<?> constructor = constructors.get(0);
            this.checkParameterized(constructor, this.field);
            return constructor;
        }
    }

    static class NoArgConstructorInstantiator
    implements ConstructorInstantiator {
        private final Object testClass;
        private final Field field;

        NoArgConstructorInstantiator(Object testClass, Field field2) {
            this.testClass = testClass;
            this.field = field2;
        }

        @Override
        public FieldInitializationReport instantiate() {
            AccessibilityChanger changer = new AccessibilityChanger();
            Constructor<?> constructor = null;
            try {
                constructor = this.field.getType().getDeclaredConstructor(new Class[0]);
                changer.enableAccess(constructor);
                Object[] noArg = new Object[]{};
                Object newFieldInstance = constructor.newInstance(noArg);
                FieldSetter.setField(this.testClass, this.field, newFieldInstance);
                FieldInitializationReport fieldInitializationReport = new FieldInitializationReport(this.field.get(this.testClass), true, false);
                return fieldInitializationReport;
            }
            catch (NoSuchMethodException e) {
                throw new MockitoException("the type '" + this.field.getType().getSimpleName() + "' has no default constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new MockitoException("the default constructor of type '" + this.field.getType().getSimpleName() + "' has raised an exception (see the stack trace for cause): " + e.getTargetException().toString(), e);
            }
            catch (InstantiationException e) {
                throw new MockitoException("InstantiationException (see the stack trace for cause): " + e.toString(), e);
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("IllegalAccessException (see the stack trace for cause): " + e.toString(), e);
            }
            finally {
                if (constructor != null) {
                    changer.safelyDisableAccess(constructor);
                }
            }
        }
    }

    private static interface ConstructorInstantiator {
        public FieldInitializationReport instantiate();
    }

    public static interface ConstructorArgumentResolver {
        public Object[] resolveTypeInstances(Class<?> ... var1);
    }
}

