/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocation;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.internal.invocation.InvocationControlAssertionError;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockitoNewInvocationControl<T>
implements NewInvocationControl<OngoingStubbing<T>> {
    private final InvocationSubstitute<T> substitute;

    public MockitoNewInvocationControl(InvocationSubstitute<T> substitute) {
        if (substitute == null) {
            throw new IllegalArgumentException("Internal error: substitute cannot be null.");
        }
        this.substitute = substitute;
    }

    @Override
    public Object invoke(Class<?> type2, Object[] args, Class<?>[] sig) throws Exception {
        Constructor<?> constructor = WhiteboxImpl.getConstructor(type2, sig);
        if (constructor.isVarArgs()) {
            Object varArgs = args[args.length - 1];
            int varArgsLength = Array.getLength(varArgs);
            Object[] oldArgs = args;
            args = new Object[args.length + varArgsLength - 1];
            System.arraycopy(oldArgs, 0, args, 0, oldArgs.length - 1);
            int i = oldArgs.length - 1;
            int j = 0;
            while (i < args.length) {
                args[i] = Array.get(varArgs, j);
                ++i;
                ++j;
            }
        }
        try {
            return this.substitute.performSubstitutionLogic(args);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure(e, type2);
            return null;
        }
    }

    @Override
    public OngoingStubbing<T> expectSubstitutionLogic(Object ... arguments) throws Exception {
        return Mockito.when(this.substitute.performSubstitutionLogic(arguments));
    }

    public InvocationSubstitute<T> getSubstitute() {
        return this.substitute;
    }

    @Override
    public synchronized Object replay(Object ... mocks) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Object verify(Object ... mocks) {
        VerificationMode verificationMode;
        Object mode = MockRepository.getAdditionalState("VerificationMode");
        if (mode != null) {
            if (!(mode instanceof VerificationMode)) throw new IllegalStateException("Internal error. VerificationMode in MockRepository was not of type " + VerificationMode.class.getName() + ".");
            verificationMode = (VerificationMode)mode;
        } else {
            verificationMode = Mockito.times(1);
        }
        Mockito.verify(this.substitute, verificationMode);
        return null;
    }

    @Override
    public synchronized Object reset(Object ... mocks) {
        Mockito.reset(this.substitute);
        return null;
    }

    public void verifyNoMoreInteractions() {
        try {
            Mockito.verifyNoMoreInteractions(this.substitute);
        }
        catch (MockitoAssertionError e) {
            InvocationControlAssertionError.updateErrorMessageForVerifyNoMoreInteractions(e);
            throw e;
        }
    }
}

