/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.utils;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;

public class JsonHelper {
    public static String getResponseJson(String what) throws IOException {
        return JsonHelper.getJson("responses/" + what + ".json");
    }

    public static String getDataJson(String filePath) throws IOException {
        return JsonHelper.getJson(filePath + ".json");
    }

    public static String getJson(String path) throws IOException {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(path);
            if (null == resource) {
                throw new ResourceNotFoundException("resource not found: [" + path + "]");
            }
            byte[] bytes = Files.readAllBytes(Paths.get(resource.toURI()));
            return new String(bytes, "UTF8");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ResourceNotFoundException
    extends RuntimeException {
        public ResourceNotFoundException(String message) {
            super(message);
        }
    }
}

