/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.agatha.crawlers.integration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.gax.grpc.testing.InProcessServer;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.xebialabs.agatha.AgathaConfiguration;
import com.xebialabs.agatha.crawlers.integration.CrawlerMock;
import com.xebialabs.agatha.crawlers.messages.BaseProbeMessage;
import com.xebialabs.agatha.crawlers.messages.CrawlerDataSourceDetails;
import com.xebialabs.agatha.crawlers.messages.CrawlerJobMetadata;
import com.xebialabs.agatha.crawlers.messages.CrawlerMessage;
import com.xebialabs.agatha.service.grpc.CrawlerApiServiceTestStub;
import com.xebialabs.agatha.shared.grpc.services.DataSourceType;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerCredentialsPackage;
import com.xebialabs.agatha.shared.grpc.services.ingest.CrawlerEndpointServiceGrpc;
import com.xebialabs.agatha.shared.grpc.services.ingest.PushCrawlerUMMessageRequest;
import com.xebialabs.agatha.shared.grpc.services.ingest.Queue;
import io.grpc.BindableService;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.stream.StreamSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCrawlerTest {
    private static final Logger logger = LoggerFactory.getLogger(BaseCrawlerTest.class);
    public static final String API_PASSWORD_FAIL = "fail!";
    private DataSourceType dataSourceType;
    protected MockWebServer mockWebServer;
    protected PushCrawlerUMMessageRequest probeRequest;
    protected PushCrawlerUMMessageRequest crawlRequest;
    protected CrawlerMock crawler;
    protected static final double THROTTLE_FACTOR = 4.0;
    protected InProcessServer<CrawlerEndpointServiceGrpc.CrawlerEndpointServiceImplBase> mockGrpcServer;
    protected CrawlerApiServiceTestStub crawlerService;
    protected CrawlerCredentialsPackage singleCredentials;
    protected CrawlerCredentialsPackage multipleCredentials;
    protected CrawlerCredentialsPackage wrongCredentials;
    protected StreamObserver streamObserver;
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();

    public BaseCrawlerTest(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
        this.configureEnv();
    }

    protected abstract CrawlerMock crawler();

    protected PushCrawlerUMMessageRequest probeRequestMessage(String pluginId, String dataSourceId, Queue queue, String tenantId) throws JsonProcessingException {
        return PushCrawlerUMMessageRequest.newBuilder().setPluginId(pluginId).setQueue(queue).setDataSourceId(dataSourceId).setTenantId(tenantId).setMessage(this.crawler().getMapper().writeValueAsString((Object)this.probeMessage(new BaseProbeMessage(), pluginId, dataSourceId))).build();
    }

    protected PushCrawlerUMMessageRequest crawlRequestMessage(String pluginId, String dataSourceId, Queue queue, String tenantId) throws JsonProcessingException {
        return PushCrawlerUMMessageRequest.newBuilder().setPluginId(pluginId).setQueue(queue).setDataSourceId(dataSourceId).setTenantId(tenantId).setMessage(this.crawler().getMapper().writeValueAsString((Object)this.crawlMessageJson(pluginId, dataSourceId))).build();
    }

    protected CrawlerMessage crawlMessageJson(String pluginId, String dataSourceId) {
        return new CrawlerMessage().setTenantId(AgathaConfiguration.getTenantId()).setPluginId(pluginId).setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(dataSourceId).setNetworkId(AgathaConfiguration.getNetworkId())).setMetadata(new CrawlerJobMetadata().setIncremental(false).setRunTimestamp(System.currentTimeMillis()));
    }

    protected String getApiEndpoint(String protocol) {
        try {
            return new URL(protocol + "://" + this.mockWebServer.getHostName() + ":" + this.mockWebServer.getPort() + "/").toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() throws IOException, IllegalAccessException, InstantiationException {
        if (this.streamObserver == null) {
            this.streamObserver = (StreamObserver)Mockito.mock(StreamObserver.class);
        }
        this.singleCredentials = this.singleCredentials();
        this.multipleCredentials = this.multipleCredentials();
        this.wrongCredentials = this.wrongCredentials();
        this.crawlerService = new CrawlerApiServiceTestStub(new ObjectMapper());
        this.crawlerService.queueService.stub.clear();
        this.mockGrpcServer = new InProcessServer((BindableService)this.crawlerService, this.dataSourceType.name());
        this.mockGrpcServer.start();
        logger.info("Started mock crawler endpoint service [{}]", (Object)this.dataSourceType.name());
    }

    private void configureEnv() {
        this.environmentVariables.set("XLINSIGHT_TENANT_ID", "testTenant");
        this.environmentVariables.set("XLINSIGHT_API_PASSWORD", "admin");
        this.environmentVariables.set("XLINSIGHT_CRAWL_YEARS_BACK", "2");
        this.environmentVariables.set("XLINSIGHT_CRAWLER_RETRY_DELAY_MIN", "0");
        Assert.assertEquals((Object)"testTenant", (Object)System.getenv("XLINSIGHT_TENANT_ID"));
        Assert.assertEquals((Object)"2", (Object)System.getenv("XLINSIGHT_CRAWL_YEARS_BACK"));
        Assert.assertEquals((Object)"0", (Object)System.getenv("XLINSIGHT_CRAWLER_RETRY_DELAY_MIN"));
        Assert.assertEquals((Object)"admin", (Object)System.getenv("XLINSIGHT_API_PASSWORD"));
    }

    protected abstract CrawlerCredentialsPackage wrongCredentials();

    protected abstract CrawlerCredentialsPackage multipleCredentials();

    protected abstract CrawlerCredentialsPackage singleCredentials();

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.mockGrpcServer.stop();
        this.mockGrpcServer.blockUntilShutdown();
        this.crawler().shutdown();
        this.crawlerService.keyValueStorage.getValues().clear();
    }

    protected <T extends BaseProbeMessage> T probeMessage(T probe, String pluginId, String dataSourceId) {
        probe.setTenantId("testTenant").setPluginId(pluginId).setDataSourceDetails(new CrawlerDataSourceDetails().setDataSourceId(dataSourceId)).setMetadata(new CrawlerJobMetadata().setIncremental(false).setRunTimestamp(new Date().getTime()));
        return probe;
    }

    protected long calculateKVStorageSize() {
        return StreamSupport.stream(this.crawlerService.keyValueStorage.list("/").spliterator(), false).count();
    }

    static {
        System.setProperty("test-mode", "true");
    }
}

