/*
 * Decompiled with CFR 0.152.
 */
package akka.http.scaladsl.server.directives;

import akka.event.LoggingAdapter;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$Path$Empty$;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.CodingDirectives$;
import akka.http.scaladsl.server.directives.ContentTypeResolver;
import akka.http.scaladsl.server.directives.FileAndResourceDirectives;
import akka.http.scaladsl.server.directives.RangeDirectives$;
import akka.http.scaladsl.server.util.TupleOps$Join$;
import akka.http.scaladsl.settings.RoutingSettings;
import java.io.File;
import scala.Function1;
import scala.MatchError;
import scala.Tuple1;
import scala.collection.Seq;
import scala.concurrent.Future;

public final class FileAndResourceDirectives$
implements FileAndResourceDirectives {
    public static FileAndResourceDirectives$ MODULE$;
    private final Directive<Tuple1<RoutingSettings>> akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings;

    static {
        new FileAndResourceDirectives$();
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(String fileName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, fileName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromFile(File file, ContentType contentType) {
        return FileAndResourceDirectives.getFromFile$((FileAndResourceDirectives)this, file, contentType);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResource(String resourceName, ContentType contentType, ClassLoader classLoader) {
        return FileAndResourceDirectives.getFromResource$(this, resourceName, contentType, classLoader);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromDirectory(String directoryName, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromDirectory$(this, directoryName, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> listDirectoryContents(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer) {
        return FileAndResourceDirectives.listDirectoryContents$(this, directories, renderer);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectory(String directory, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectory$(this, directory, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromBrowseableDirectories(Seq<String> directories, FileAndResourceDirectives.DirectoryRenderer renderer, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromBrowseableDirectories$(this, directories, renderer, resolver);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> getFromResourceDirectory(String directoryName, ClassLoader classLoader, ContentTypeResolver resolver) {
        return FileAndResourceDirectives.getFromResourceDirectory$(this, directoryName, classLoader, resolver);
    }

    @Override
    public ClassLoader _defaultClassLoader() {
        return FileAndResourceDirectives._defaultClassLoader$(this);
    }

    @Override
    public ClassLoader getFromResource$default$3() {
        return FileAndResourceDirectives.getFromResource$default$3$(this);
    }

    @Override
    public ClassLoader getFromResourceDirectory$default$2() {
        return FileAndResourceDirectives.getFromResourceDirectory$default$2$(this);
    }

    public Directive<Tuple1<RoutingSettings>> akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings() {
        return this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings;
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withTrailingSlash(String path) {
        return path.endsWith("/") ? path : new StringBuilder(0).append(path).append('/').toString();
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath(String basePath, Uri.Path path, LoggingAdapter log, char separator) {
        String string = this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(basePath, path, log, separator);
        String string2 = "".equals(string) ? "" : this.checkIsSafeDescendant(basePath, string, log);
        return string2;
    }

    public char akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeDirectoryChildPath$default$4() {
        return File.separatorChar;
    }

    public String akka$http$scaladsl$server$directives$FileAndResourceDirectives$$safeJoinPaths(String base, Uri.Path path, LoggingAdapter log, char separator) {
        return this.rec$1(path.startsWithSlash() ? path.tail() : path, FileAndResourceDirectives$.rec$default$2$1(base), base, path, log, separator);
    }

    private String checkIsSafeDescendant(String basePath, String finalPath, LoggingAdapter log) {
        String string;
        File baseFile = new File(basePath);
        File finalFile = new File(finalPath);
        String canonicalFinalPath = finalFile.getCanonicalPath();
        if (!canonicalFinalPath.startsWith(baseFile.getCanonicalPath())) {
            log.warning(new StringBuilder(92).append("[").append(finalFile).append("] points to a location that is not part of [").append(baseFile).append("]. This might be a directory ").append("traversal attempt.").toString());
            string = "";
        } else {
            string = canonicalFinalPath;
        }
        return string;
    }

    private final String rec$1(Uri.Path p, StringBuilder result, String base$1, Uri.Path path$1, LoggingAdapter log$1, char separator$1) {
        String string;
        block4: {
            Uri.Path path;
            block5: {
                String head;
                while (true) {
                    if (Uri$Path$Empty$.MODULE$.equals(path = p)) {
                        string = result.toString();
                        break block4;
                    }
                    if (path instanceof Uri.Path.Slash) {
                        Uri.Path.Slash slash = (Uri.Path.Slash)path;
                        Uri.Path tail = slash.tail();
                        result = result.append(separator$1);
                        p = tail;
                        continue;
                    }
                    if (!(path instanceof Uri.Path.Segment)) break block5;
                    Uri.Path.Segment segment = (Uri.Path.Segment)path;
                    head = segment.head();
                    Uri.Path.SlashOrEmpty tail = segment.tail();
                    if (head.indexOf(47) >= 0 || head.indexOf(92) >= 0) break;
                    String string2 = head;
                    String string3 = "..";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        break;
                    }
                    result = result.append(head);
                    p = tail;
                }
                log$1.warning("File-system path for base [{}] and Uri.Path [{}] contains suspicious path segment [{}], GET access was disallowed", base$1, path$1, head);
                string = "";
                break block4;
            }
            throw new MatchError(path);
        }
        return string;
    }

    private static final StringBuilder rec$default$2$1(String base$1) {
        return new StringBuilder(base$1);
    }

    private FileAndResourceDirectives$() {
        MODULE$ = this;
        FileAndResourceDirectives.$init$(this);
        this.akka$http$scaladsl$server$directives$FileAndResourceDirectives$$withRangeSupportAndPrecompressedMediaTypeSupportAndExtractSettings = (Directive)((Directive)RangeDirectives$.MODULE$.withRangeSupport().$amp(ConjunctionMagnet$.MODULE$.fromDirective(CodingDirectives$.MODULE$.withPrecompressedMediaTypeSupport(), TupleOps$Join$.MODULE$.join0P()))).$amp(ConjunctionMagnet$.MODULE$.fromDirective(BasicDirectives$.MODULE$.extractSettings(), TupleOps$Join$.MODULE$.join0P()));
    }
}

