/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.IOSettings;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.impl.io.TcpConnectionStage;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.util.ByteString;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!B\u0001\u0003\u0001!Q!aF%oG>l\u0017N\\4D_:tWm\u0019;j_:\u001cF/Y4f\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005S6\u0004HN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T\u0011!C\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u0017A\u0019AbD\t\u000e\u00035Q!A\u0004\u0004\u0002\u000bM$\u0018mZ3\n\u0005Ai!AC$sCBD7\u000b^1hKB!!cE\u000b\u0016\u001b\u00051\u0011B\u0001\u000b\u0007\u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005!Q\u000f^5m\u0013\tQrC\u0001\u0006CsR,7\u000b\u001e:j]\u001eD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000bG>tg.Z2uS>t7\u0001\u0001\t\u0003?\tj\u0011\u0001\t\u0006\u0003C!\tQ!Y2u_JL!a\t\u0011\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013a\u00018fi*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005I\u0001.\u00197g\u00072|7/\u001a\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b\u0005>|G.Z1o\u0011!9\u0004A!A!\u0002\u0013A\u0014AC5p'\u0016$H/\u001b8hgB\u0011!#O\u0005\u0003u\u0019\u0011!\"S(TKR$\u0018N\\4t\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u0019a\u0014N\\5u}Q)a\bQ!C\u0007B\u0011q\bA\u0007\u0002\u0005!)Ad\u000fa\u0001=!)Qe\u000fa\u0001M!)qf\u000fa\u0001a!)qg\u000fa\u0001q!9Q\t\u0001b\u0001\n\u00131\u0015A\u00045bg\n+WM\\\"sK\u0006$X\rZ\u000b\u0002\u000fB\u0011\u0001JT\u0007\u0002\u0013*\u0011!jS\u0001\u0007CR|W.[2\u000b\u00051k\u0015AC2p]\u000e,(O]3oi*\u0011\u0001DK\u0005\u0003\u001f&\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB)\u0001A\u0003%q)A\biCN\u0014U-\u001a8De\u0016\fG/\u001a3!\u0011\u001d\u0019\u0006A1A\u0005\u0002Q\u000bqAY=uKNLe.F\u0001V!\r\u0011b+F\u0005\u0003/\u001a\u0011Q!\u00138mKRDa!\u0017\u0001!\u0002\u0013)\u0016\u0001\u00032zi\u0016\u001c\u0018J\u001c\u0011\t\u000fm\u0003!\u0019!C\u00019\u0006A!-\u001f;fg>+H/F\u0001^!\r\u0011b,F\u0005\u0003?\u001a\u0011aaT;uY\u0016$\bBB1\u0001A\u0003%Q,A\u0005csR,7oT;uA!)1\r\u0001C!I\u0006\t\u0012N\\5uS\u0006d\u0017\t\u001e;sS\n,H/Z:\u0016\u0003\u0015\u0004\"A\u00054\n\u0005\u001d4!AC!uiJL'-\u001e;fg\"9\u0011\u000e\u0001b\u0001\n\u0003Q\u0017!B:iCB,W#A\t\t\r1\u0004\u0001\u0015!\u0003\u0012\u0003\u0019\u0019\b.\u00199fA!)a\u000e\u0001C!_\u0006Y1M]3bi\u0016dunZ5d)\t\u00018\u000f\u0005\u0002\rc&\u0011!/\u0004\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\")A/\u001ca\u0001K\u0006\u0019\u0012N\u001c5fe&$X\rZ!uiJL'-\u001e;fg\")a\u000f\u0001C!o\u0006AAo\\*ue&tw\rF\u0001y!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a\u001f\u001a\u000e\u0003qT!!`\u000f\u0002\rq\u0012xn\u001c;?\u0013\ty('\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fJB3\u0001AA\u0005!\u0011\tY!!\u0005\u000e\u0005\u00055!bAA\b\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000e")
@InternalApi
public class IncomingConnectionStage
extends GraphStage<FlowShape<ByteString, ByteString>> {
    private final ActorRef connection;
    private final InetSocketAddress remoteAddress;
    private final boolean halfClose;
    private final IOSettings ioSettings;
    private final AtomicBoolean hasBeenCreated;
    private final Inlet<ByteString> bytesIn;
    private final Outlet<ByteString> bytesOut;
    private final FlowShape<ByteString, ByteString> shape;

    private AtomicBoolean hasBeenCreated() {
        return this.hasBeenCreated;
    }

    public Inlet<ByteString> bytesIn() {
        return this.bytesIn;
    }

    public Outlet<ByteString> bytesOut() {
        return this.bytesOut;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("IncomingConnection");
    }

    @Override
    public FlowShape<ByteString, ByteString> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        if (this.hasBeenCreated().get()) {
            throw new IllegalStateException("Cannot materialize an incoming connection Flow twice.");
        }
        this.hasBeenCreated().set(true);
        return new TcpConnectionStage.TcpStreamLogic((FlowShape<ByteString, ByteString>)this.shape(), new TcpConnectionStage.Inbound(this.connection, this.halfClose, this.ioSettings), this.remoteAddress);
    }

    public String toString() {
        return new StringBuilder(10).append("TCP-from(").append(this.remoteAddress).append(")").toString();
    }

    public IncomingConnectionStage(ActorRef connection, InetSocketAddress remoteAddress, boolean halfClose, IOSettings ioSettings) {
        this.connection = connection;
        this.remoteAddress = remoteAddress;
        this.halfClose = halfClose;
        this.ioSettings = ioSettings;
        this.hasBeenCreated = new AtomicBoolean(false);
        this.bytesIn = Inlet$.MODULE$.apply("IncomingTCP.in");
        this.bytesOut = Outlet$.MODULE$.apply("IncomingTCP.out");
        this.shape = new FlowShape<ByteString, ByteString>(this.bytesIn(), this.bytesOut());
    }
}

