/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.impact.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=CrawlerDataWrapperSerializer.class)
public class CrawlerDataWrapper
implements Serializable {
    public static final String STREAM_PLACEHOLDER = "@~DATA_STREAM~@";
    private Map<String, Object> values = new HashMap<String, Object>();

    private CrawlerDataWrapper(String type2) {
        this.setType(type2);
    }

    public static CrawlerDataWrapper forType(String type2) {
        return new CrawlerDataWrapper(type2);
    }

    public void setType(String type2) {
        this.values.put("type", type2);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    @JsonIgnore
    public CrawlerDataWrapper setValue(String key, Object val) {
        this.values.put(key, val);
        return this;
    }

    public static class CrawlerDataWrapperSerializer
    extends JsonSerializer<CrawlerDataWrapper> {
        @Override
        public void serialize(CrawlerDataWrapper data, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            Map<String, Object> map = data.getValues();
            gen.writeStartObject();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                char[] buffer;
                if (entry.getValue() instanceof String) {
                    gen.writeStringField(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof byte[]) {
                    buffer = (char[])entry.getValue();
                    gen.writeFieldName(entry.getKey());
                    gen.writeRawValue(buffer, 0, buffer.length);
                    continue;
                }
                if (entry.getValue() instanceof char[]) {
                    buffer = (char[])entry.getValue();
                    gen.writeFieldName(entry.getKey());
                    gen.writeString(buffer, 0, buffer.length);
                    continue;
                }
                if (entry.getValue() instanceof Collection) {
                    Collection list = (Collection)entry.getValue();
                    gen.writeArrayFieldStart(entry.getKey());
                    for (Object item : list) {
                        gen.writeObject(item);
                    }
                    gen.writeEndArray();
                    continue;
                }
                if (entry.getValue() instanceof Reader) {
                    gen.writeStringField(entry.getKey(), CrawlerDataWrapper.STREAM_PLACEHOLDER);
                    continue;
                }
                gen.writeObjectField(entry.getKey(), entry.getValue());
            }
            gen.writeEndObject();
        }
    }
}

