/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas.deployit;

import com.atlassian.crowd.application.jaas.deployit.CrowdGroupPrincipal;
import com.atlassian.crowd.application.jaas.deployit.CrowdUserPrincipal;
import com.atlassian.crowd.application.jaas.deployit.SecurityServerClientPool;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.principal.PrincipalIteratorAdapter;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;

public class CrowdPrincipalProvider
implements PrincipalProvider {
    protected static final Log log = LogFactory.getLog(CrowdPrincipalProvider.class);
    private static final Map<Principal, List<Principal>> groupCache = new MapMaker().expireAfterAccess(10L, TimeUnit.SECONDS).makeMap();

    public Principal getPrincipal(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPrincipal for " + s));
        }
        return new CrowdUserPrincipal(s);
    }

    public PrincipalIterator findPrincipals(String s) {
        throw new UnsupportedOperationException("Cannot invoke findPrincipals(String) on LdapPrincipalProvider: not implemented.");
    }

    public PrincipalIterator findPrincipals(String s, int i) {
        throw new UnsupportedOperationException("Cannot invoke getPrincipals(String,int) on CrowdPrincipalProvider: not implemented.");
    }

    public PrincipalIterator getPrincipals(int i) {
        throw new UnsupportedOperationException("Cannot invoke getPrincipals(int) on CrowdPrincipalProvider: not implemented.");
    }

    public PrincipalIterator getGroupMembership(Principal principal) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGroupMembership " + principal));
        }
        if (groupCache.containsKey(principal)) {
            log.debug((Object)("Cache hit for " + principal));
            return new PrincipalIteratorAdapter((Collection)groupCache.get(principal));
        }
        ArrayList groupPrincipals = Lists.newArrayList();
        try {
            String[] groups;
            for (String role : groups = SecurityServerClientPool.INSTANCE.findGroupMemberships(principal.getName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  add " + role));
                }
                groupPrincipals.add(new CrowdGroupPrincipal(role));
            }
            groupCache.put(principal, groupPrincipals);
            return new PrincipalIteratorAdapter((Collection)groupPrincipals);
        }
        catch (Exception e) {
            log.error((Object)" getGroupMembership error ", (Throwable)e);
            throw new RuntimeException(e.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    public void init(Properties properties) {
        log.debug((Object)("init " + properties));
    }

    public void close() {
        log.debug((Object)"close.....");
    }

    public boolean canReadPrincipal(Session session, Principal principal) {
        return true;
    }
}

