/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.application.jaas.deployit;

import com.atlassian.crowd.application.jaas.AbstractLoginModule;
import com.atlassian.crowd.application.jaas.deployit.CrowdPrincipalProvider;
import com.atlassian.crowd.application.jaas.deployit.SecurityServerClientPool;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;

public class DeployitCrowdLoginModule
extends AbstractLoginModule {
    private boolean storeToken = false;
    private boolean useToken = false;
    private String applicationName;
    private Properties options = new Properties();
    private String principalProviderClass = CrowdPrincipalProvider.class.getName();
    private AtomicReference<PrincipalProvider> principalProvider = new AtomicReference();

    @Override
    public void preInitialise(Map options) {
        this.options.putAll((Map<?, ?>)options);
        this.log.debug((Object)("Module Options: " + options));
        this.useToken = "true".equalsIgnoreCase((String)options.get("useToken"));
        this.storeToken = this.useToken || "true".equalsIgnoreCase((String)this.options.get("storeToken"));
        this.applicationName = this.options.getProperty("application.name");
        super.preInitialise(this.options);
    }

    @Override
    protected Set authenticate(Map credentials) throws LoginException {
        String token;
        String user = (String)credentials.get("javax.security.auth.login.name");
        char[] pass = (char[])credentials.get("javax.security.auth.login.password");
        if (pass == null) {
            throw new LoginException("Password not supplied.");
        }
        if (!this.useToken && user == null) {
            throw new LoginException("User not supplied.");
        }
        if (this.useToken) {
            token = new String(pass);
            try {
                SOAPPrincipal SOAPPrincipal2 = SecurityServerClientPool.INSTANCE.findPrincipalByToken(token);
                user = SOAPPrincipal2.getName();
            }
            catch (Exception e) {
                this.log.error((Object)"findPrincipalByToken error", (Throwable)e);
                throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
            }
        }
        UserAuthenticationContext context = new UserAuthenticationContext();
        context.setName(user);
        context.setApplication(this.applicationName);
        PasswordCredential passwordCredential = new PasswordCredential(new String(pass), this.storeToken);
        context.setCredential(passwordCredential);
        try {
            token = SecurityServerClientPool.INSTANCE.authenticatePrincipal(context);
        }
        catch (Exception e) {
            this.log.error((Object)"authenticatePrincipal error", (Throwable)e);
            throw new LoginException(e.getClass().getName() + ": " + e.getMessage());
        }
        if (this.storeToken) {
            credentials.put("javax.security.auth.login.password", token.toCharArray());
        }
        return this.createPrincipals(user);
    }

    protected Set createPrincipals(String user) throws LoginException {
        this.log.debug((Object)String.format("create Principals %s", user));
        HashSet<Principal> principals = new HashSet<Principal>();
        PrincipalProvider provider = this.getPrincipalProvider();
        Principal userPrincipal = provider.getPrincipal(user);
        principals.add(userPrincipal);
        PrincipalIterator groupMembership = provider.getGroupMembership(userPrincipal);
        while (groupMembership.hasNext()) {
            Principal groupPrincipal = groupMembership.nextPrincipal();
            principals.add(groupPrincipal);
        }
        principals.add((Principal)EveryonePrincipal.getInstance());
        this.log.debug(principals);
        return principals;
    }

    private PrincipalProvider getPrincipalProvider() {
        PrincipalProvider principalProvider = this.principalProvider.get();
        if (principalProvider == null) {
            this.log.debug((Object)("Instantiating provider class " + this.principalProviderClass));
            principalProvider = (PrincipalProvider)DeployitCrowdLoginModule.newInstance(this.principalProviderClass);
            principalProvider.init(DeployitCrowdLoginModule.toProperties(this.options));
            this.principalProvider.compareAndSet(null, principalProvider);
        }
        return this.principalProvider.get();
    }

    private static Object newInstance(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(String.format("Unable to instantiate principal provider class '%s'", className), exception);
        }
    }

    private static Properties toProperties(Properties propertyEntries) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)propertyEntries);
        return properties;
    }
}

