package com.xebialabs.deployit.core.rest.api

import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, PropertyDescriptor, PropertyKind, Type}
import com.xebialabs.deployit.plugin.api.udm.{Container, Deployable, Deployed}

import java.util
import java.util.stream.Collectors.toList

object MetadataServiceUtil {

  def inheritanceMap(descriptors: util.List[Descriptor]): util.Map[String, util.Set[String]] = {
    val inheritanceMap: util.Map[String, util.Set[String]] = new util.HashMap[String, util.Set[String]]

    def addToInheritanceMap(_type: AnyRef, descriptor: String): Unit = {
      if (_type == null) return
      val key = _type match {
        case t: Type => t.toString
        case s: String => s
        case _ => return
      }
      inheritanceMap.computeIfAbsent(key, (emptySet: String) => new util.HashSet[String]).add(descriptor)
    }

    def getChildren(_type: Type, descriptors: util.List[Descriptor]): util.List[Descriptor] =
      descriptors.stream().filter((descriptor: Descriptor) => isAssignableFrom(_type, descriptor)).collect(toList())

    def isAssignableFrom(_type: Type, descriptor: Descriptor): Boolean =
      descriptor.getType != null && ((descriptor.getType == _type) ||
        _type.getDescriptor.getSuperClasses.contains(_type) ||
        _type.getDescriptor.getInterfaces.contains(_type))

    descriptors.forEach((descriptor: Descriptor) => {
      addToInheritanceMap(descriptor.getRoot.toString, descriptor.getType.toString)
      descriptor.getPropertyDescriptors.stream.filter((pd: PropertyDescriptor) =>
        !pd.isHidden && pd.isAsContainment).forEach((propertyDescriptor: PropertyDescriptor) => {
        if ((propertyDescriptor.getKind eq PropertyKind.SET_OF_CI) || (propertyDescriptor.getKind eq PropertyKind.LIST_OF_CI)) {
          val childrenDescriptors: util.List[Descriptor] = getChildren(propertyDescriptor.getReferencedType, descriptors)
          childrenDescriptors.forEach((childrenDescriptor: Descriptor) => addToInheritanceMap(descriptor.getType, childrenDescriptor.getType.toString))
        } else if (isAssignableFrom(Type.valueOf(classOf[Deployed[_ <: Deployable, _ <: Container]]), descriptor) && (propertyDescriptor.getReferencedType eq Type.valueOf(classOf[Container]))) {
          val childrenDescriptors: util.List[Descriptor] = getChildren(descriptor.getContainerType, descriptors)
          childrenDescriptors.forEach((childrenDescriptor: Descriptor) => addToInheritanceMap(childrenDescriptor.getType, descriptor.getType.toString))
        } else {
          addToInheritanceMap(propertyDescriptor.getReferencedType, descriptor.getType.toString)
        }
      })
    })

    inheritanceMap
  }

}
