package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.core.api.dto.Comparison;
import com.xebialabs.xltype.serialization.json.JsonWriter;

public class ComparisonJsonConverter {

    public String toJson(Comparison comparison) {
        JsonWriter writer = new JsonWriter();
        toJson(comparison, writer);
        return writer.toString();
    }

    public void toJson(final Comparison comparison, final JsonWriter writer) {
        writer.object();
        writer.key("lines");
        writer.array();
        for (Comparison.ComparisonLine line : comparison.getLines()) {
            writer.object();
            writer.key("key").value(line.getKey());
            writer.key("referenceValue").value(line.getReferenceValue());
            writer.key("values");
            writer.array();
            for (String value : line.getValues()) {
                writer.value(value);
            }
            writer.endArray();
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }
}
