package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.api.dto.PermissionDto;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePermissionsMap;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;


@Component
public class DtoWriter {
    public List<Role> writeRoles(List<com.xebialabs.deployit.security.Role> roles) {
        return roles.stream().map(DtoWriter::writeRole).collect(Collectors.toList());
    }

    private static Role writeRole(com.xebialabs.deployit.security.Role role) {
        return new Role(role.getId(), role.getName());
    }

    public List<RolePrincipals> writeRoleAssignments(List<com.xebialabs.deployit.security.Role> roles) {
        return roles.stream()
                .map(r -> new RolePrincipals(writeRole(r), r.getPrincipals()))
                .collect(Collectors.toList());
    }

    public List<RolePermissions> writeRolePermissions(Map<com.xebialabs.deployit.security.Role, Set<Permission>> multimap) {
        return multimap.keySet()
                .stream()
                .map(role -> new RolePermissions(writeRole(role), writePermissions(multimap.get(role))))
                .collect(Collectors.toList());
    }

    public Map<String, Object> writeAllPermissionsForRole(Map<com.xebialabs.deployit.security.Role, Set<Permission>> multimap, Boolean isSecureCi, String rootCI) {
            List<RolePermissionsMap> rolePermissions = multimap.keySet()
                    .stream()
                    .map(role -> new RolePermissionsMap(writeRole(role), writePermissionsAsMap(multimap.get(role), rootCI)))
                    .toList();

            Map<String, Object> result = new LinkedHashMap<>();
            result.put("inherited", !isSecureCi);
            result.put("roles", rolePermissions);
            return result;
    }

    private static List<String> writePermissions(Collection<Permission> permissions) {
        return permissions.stream().map(Permission::getPermissionName).collect(Collectors.toList());
    }

    private static List<PermissionDto> writePermissionsAsMap(Collection<Permission> permissions, String rootCI) {
        Set<String> enabled = permissions.stream()
                .map(Permission::getPermissionName)
                .collect(Collectors.toSet());

        List<com.xebialabs.deployit.engine.api.security.Permission> allDataPermissions =
                writeAllDataPermissionsForCI(Permission.getAll(), rootCI);

        return allDataPermissions.stream()
                .map(p -> new PermissionDto(p.getPermissionName(), enabled.contains(p.getPermissionName())))
                .toList();
    }

    public static List<com.xebialabs.deployit.engine.api.security.Permission> writeReferenceDataPermissions(Collection<Permission> values) {
        return values.stream()
                .map(p -> new com.xebialabs.deployit.engine.api.security.Permission(
                        p.getPermissionName(),
                        p.getLevel().name(),
                        p.getRoot() != null ? p.getRoot().getRootNodeName() : null))
                .collect(Collectors.toList());
    }
    public static List<com.xebialabs.deployit.engine.api.security.Permission> writeAllDataPermissionsForCI(Collection<Permission> values, String rootCI) {
        return values.stream()
                .filter(p ->  (p.getLevel() == PermissionHandler.Level.CI || p.getLevel() == PermissionHandler.Level.BOTH) &&
                        (p.getRoot() == null || (p.getRoot() != null &&
                        p.getRoot().getRootNodeName().equals(rootCI))))
                .map(p -> new com.xebialabs.deployit.engine.api.security.Permission(
                        p.getPermissionName(),
                        p.getLevel().name(),
                        p.getRoot() != null ? p.getRoot().getRootNodeName() : null))
                .collect(Collectors.toList());
    }
}
