/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.deployit.engine.api.dto.AbstractDto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "licensed-ci-usage")
public class LicensedCiUsageDto extends AbstractDto {
    private String ciType;
    private int licensed;
    private int inUse;

    public LicensedCiUsageDto() {
    }

    public LicensedCiUsageDto(String ciType, int licensed, int inUse) {
        this.ciType = ciType;
        this.licensed = licensed;
        this.inUse = inUse;
    }

    @XmlElement(name = "ci-type")
    public String getCiType() {
        return ciType;
    }

    public void setCiType(String ciType) {
        this.ciType = ciType;
    }

    @XmlElement(name = "licensed")
    public int getLicensed() {
        return licensed;
    }

    public void setLicensed(int licensed) {
        this.licensed = licensed;
    }

    @XmlElement(name = "in-use")
    public int getInUse() {
        return inUse;
    }

    public void setInUse(int inUse) {
        this.inUse = inUse;
    }
}
