/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.core.api.dto;

import com.xebialabs.deployit.engine.api.security.Role;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import java.util.ArrayList;
import java.util.List;

@XmlRootElement
public class RolePermissions extends AbstractDTO {
    
    private Role role;

    private List<String> permissions = new ArrayList<>();

    public RolePermissions() {
    }

    public RolePermissions(Role role, List<String> permissions) {
        this.role = role;
        this.permissions = permissions;
    }

    @XmlElement
    public Role getRole() {
        return role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @XmlElement
    public List<String> getPermissions() {
        return permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public void grant(String permission) {
        this.permissions.add(permission);
    }

    public void revoke(String permission) {
        this.permissions.remove(permission);
    }
}
