package com.xebialabs.deployit.setup

import com.xebialabs.deployit.setup.UpgradeHelper.{DiscoveredPlugin, PluginsFolderName}
import grizzled.slf4j.Logging
import org.apache.commons.io.FileUtils

import java.io.File
import scala.util.{Failure, Success, Try}

class FileCopier extends Logging {

  def tryCopy(previousInstallation: String, fileName: String, optional: Boolean = false): Unit = {
    val existingFile = new File(previousInstallation, fileName)
    val newFile = new File(fileName)

    if (existingFile.isDirectory) copyDirectory(existingFile, newFile, fileName)
    else tryCopyFile(fileName, existingFile, newFile, optional)
  }

  def tryCopyPlugin(sourceLocation: DiscoveredPlugin, destinationSubfolderName: String, previousInstallation: String): Unit = {
    val fileName = sourceLocation.fileName
    val existingFile = new File(previousInstallation, s"$PluginsFolderName${File.separator}${sourceLocation.path}")
    val newFile = new File(s"$PluginsFolderName${File.separator}$destinationSubfolderName${File.separator}$fileName")

    tryCopyFile(fileName, existingFile, newFile)
  }

  private def tryCopyFile(fileName: String, existingFile: File, newFile: File, optional: Boolean = false): Unit = {
    Try(FileUtils.copyFile(existingFile, newFile)) match {
      case Success(_) => logger.info(s"File [$fileName] was copied to the new installation.")
      case Failure(exception) => {
        if (optional) {
          logger.error(s"File [$fileName] not found in source directory. Skipping it.....")
        } else {
          logger.error(s"Error while copying file [$fileName].", exception)
        }
      }
    }
  }

  private def copyDirectory(existingFile: File, newFile: File, fileName: String): Unit = {
    Try(FileUtils.copyDirectory(existingFile, newFile)) match {
      case Success(_) => logger.info(s"Directory [$fileName] was copied to the new installation.")
      case Failure(exception) => logger.error(s"Error while copying directory [$fileName].", exception)
    }
  }
}
