package com.xebialabs.deployit.rest.mappers

import java.util

import com.xebialabs.deployit.engine.spi.exception.DeployitException
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.service.validation.Validator

object DeployitExceptionHandler {

  def getValidationEntity: PartialFunction[DeployitException, Any] = new PartialFunction[DeployitException, Any] {
    def isDefinedAt(exception: DeployitException): Boolean =
      exception.isInstanceOf[Validator.ValidationsFailedException] && exception.getEntity.isInstanceOf[util.Collection[_]]

    def apply(exception: DeployitException): Any = {
      val cis = exception.getEntity.asInstanceOf[util.List[ConfigurationItem]]
      new Validator.ValidatedCis(cis)
    }
  }

  def getEntity: PartialFunction[DeployitException, Any] = new PartialFunction[DeployitException, Any] {
    def isDefinedAt(x: DeployitException): Boolean = true

    def apply(exception: DeployitException): Any = exception.getEntity
  }

  def getJsonEntity(exception: DeployitException): Any = {
    val handleGetEntity = getValidationEntity orElse getEntity
    handleGetEntity(exception)
  }
}
