/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class ServerLaunchOptions {
    @Option(name="-setup", usage="(Re-)run the setup")
    private boolean doSetup = false;
    @Option(name="-reinitialize", usage="Reinitialize the repository, only useful with -setup")
    private boolean reinitialize = false;
    @Option(name="-force")
    private boolean force;
    @Option(name="-force-upgrades", usage="Force execution of upgrades at startup")
    private boolean forceUpgrades;
    @Option(name="-setup-defaults", usage="Use the given file for defaults during setup (e.g. use `-setup-defaults conf/poc-setup.properties` to run with in-memory database (NB! In-memory database NOT recommended for production)).")
    private String defaultsFile;
    @Option(name="-repository-keystore-password", usage="The password to open the repository-keystore.jceks file, if not given, the server will prompt you.")
    private String repositoryKeystorePassword;
    @Option(name="-help", usage="Prints this usage message")
    private boolean printUsage = false;
    @Option(name="-previous-installation", usage="Path to previous XL Deploy installation to copy the configuration from")
    private String previousInstallation;
    @Option(name="-external-config", usage="Enable external configuration")
    private Boolean externalConfig;
    @Option(name="-plugin-source", usage="Defines where the plugins will be loaded from. Allowed values: 'filesystem', 'database'. Defaults to 'database' if not specified")
    private String pluginSource;
    @Option(name="-profiling", usage="When used, the application runs with profiling enabled. Important information is captured in log file log/profiling.log")
    private boolean profilingEnabled;
    private static volatile ServerLaunchOptions instance;

    public boolean isDoSetup() {
        return this.doSetup;
    }

    public void setDoSetup(boolean doSetup) {
        this.doSetup = doSetup;
    }

    public boolean isReinitialize() {
        return this.reinitialize;
    }

    public void setReinitialize(boolean reinitialize) {
        this.reinitialize = reinitialize;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForceUpgrades() {
        return this.forceUpgrades;
    }

    public void setForceUpgrades(boolean forceUpgrades) {
        this.forceUpgrades = forceUpgrades;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    public String getDefaultsFile() {
        return this.defaultsFile;
    }

    public void setDefaultsFile(String defaultsFile) {
        this.defaultsFile = defaultsFile;
    }

    public String getRepositoryKeystorePassword() {
        return this.repositoryKeystorePassword;
    }

    public void setRepositoryKeystorePassword(String repositoryKeystorePassword) {
        this.repositoryKeystorePassword = repositoryKeystorePassword;
    }

    public void setPreviousInstallation(String previousInstallation) {
        this.previousInstallation = previousInstallation;
    }

    public String getPreviousInstallation() {
        return this.previousInstallation;
    }

    public Boolean isExternalConfig() {
        return this.externalConfig;
    }

    public void setExternalConfig(Boolean externalConfig) {
        this.externalConfig = externalConfig;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    public String getPluginSource() {
        return this.pluginSource;
    }

    public void setPluginSource(String pluginSource) {
        this.pluginSource = pluginSource;
    }

    public static ServerLaunchOptions parseCommandLine(String[] args) {
        ServerLaunchOptions options = new ServerLaunchOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                ServerLaunchOptions.printUsage(parser, System.out);
                return null;
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            ServerLaunchOptions.printUsage(parser, System.err);
            return null;
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        stream.println("Supported options:");
        parser.printUsage((OutputStream)stream);
    }

    public static ServerLaunchOptions getInstance() {
        return instance;
    }

    public static void setInstance(ServerLaunchOptions launchOptions) {
        instance = launchOptions;
    }
}

