/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit;

import com.xebialabs.deployit.HttpErrorHandler;
import com.xebialabs.deployit.errors.LicenseMissingErrorHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.Callback;

public class CustomErrorHandler
extends ErrorHandler {
    private final HttpErrorHandler[] handlers;

    public CustomErrorHandler() {
        this(new LicenseMissingErrorHandler());
    }

    public CustomErrorHandler(HttpErrorHandler ... handlers) {
        this.handlers = handlers;
    }

    protected boolean generateAcceptableResponse(Request request, Response response, Callback callback, String contentType, List<Charset> charsets, int code, String message, Throwable cause) throws IOException {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                Arrays.stream(this.handlers).filter(h -> h.canHandle(httpServletRequest, code)).findFirst().ifPresent(h -> h.changeResponse(httpServletResponse));
            }
        }
        return super.generateAcceptableResponse(request, response, callback, contentType, charsets, code, message, cause);
    }

    protected void writeErrorHtml(Request request, Writer writer, Charset charset, int code, String message, Throwable cause, boolean showStacks) throws IOException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            Optional<HttpErrorHandler> handler = Arrays.stream(this.handlers).filter(h -> h.canHandle(httpServletRequest, code)).findFirst();
            handler.get().writeErrorContent(writer);
        } else {
            super.writeErrorHtml(request, writer, charset, code, message, cause, showStacks);
        }
    }
}

