/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHeadersEncodedAsParametersFilter
implements Filter {
    public static final String X_HEADER_PREFIX = "X-Header-";
    private static Logger logger = LoggerFactory.getLogger(RequestHeadersEncodedAsParametersFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("Initialized to check for Http Headers in Post Request parameters.");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletRequest filteredRequest = request;
        if (request instanceof HttpServletRequest) {
            filteredRequest = RequestHeadersEncodedAsParametersFilter.processRequest((HttpServletRequest)request);
        }
        chain.doFilter(filteredRequest, response);
    }

    private static ServletRequest processRequest(HttpServletRequest request) {
        return new HttpHeadersEncodedAsParametersServletRequest(request);
    }

    private static class HttpHeadersEncodedAsParametersServletRequest
    extends HttpServletRequestWrapper {
        HttpHeadersEncodedAsParametersServletRequest(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            String header = this.getHeaderFromParameters(name);
            if (header != null) {
                logger.debug("Header {} resolved from request parameters", (Object)name);
            } else {
                header = super.getHeader(name);
            }
            return header;
        }

        private String getHeaderFromParameters(String name) {
            String headerAsParam = RequestHeadersEncodedAsParametersFilter.X_HEADER_PREFIX + name;
            return this.getParameter(headerAsParam);
        }

        public String getContentType() {
            String contentType = this.getHeaderFromParameters("Content-Type");
            if (contentType == null) {
                contentType = super.getContentType();
            }
            return contentType;
        }

        public Enumeration<String> getHeaders(String name) {
            ArrayList headers = Collections.list(super.getHeaders(name));
            String headerFromParam = this.getHeaderFromParameters(name);
            if (headerFromParam != null) {
                logger.debug("Header {} resolved from request parameters", (Object)name);
                headers.add(headerFromParam);
            }
            return Collections.enumeration(headers);
        }

        public Enumeration<String> getHeaderNames() {
            ArrayList headers = Collections.list(super.getHeaderNames());
            Enumeration params = this.getParameterNames();
            while (params.hasMoreElements()) {
                String headerInParam;
                String param = (String)params.nextElement();
                if (!param.startsWith(RequestHeadersEncodedAsParametersFilter.X_HEADER_PREFIX) || headers.contains(headerInParam = param.substring(RequestHeadersEncodedAsParametersFilter.X_HEADER_PREFIX.length()))) continue;
                logger.debug("Header {} resolved from request parameters", (Object)headerInParam);
                headers.add(headerInParam);
            }
            return Collections.enumeration(headers);
        }
    }
}

