/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DeployfileService;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.deployfile.DirectorySpec;
import com.xebialabs.deployit.deployfile.ForDirectories;
import com.xebialabs.deployit.deployfile.XldSpec;
import com.xebialabs.deployit.deployfile.execute.CiCommand;
import com.xebialabs.deployit.deployfile.execute.CiCommandCreator;
import com.xebialabs.deployit.deployfile.execute.CommandExecutor;
import com.xebialabs.deployit.deployfile.execute.DeleteCiCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileExecutor;
import com.xebialabs.deployit.deployfile.execute.DeployfileReferenceResolver;
import com.xebialabs.deployit.deployfile.export.DeployfileGenerator;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u00015\u0011!\u0003R3qY>Lh-\u001b7f%\u0016\u001cx.\u001e:dK*\u00111\u0001B\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0006\r\u0005!1m\u001c:f\u0015\t9\u0001\"\u0001\u0005eKBdw._5u\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0002\u0002\u000fM,7-\u001e:fI&\u00111\u0003\u0005\u0002\u0018\u0003\n\u001cHO]1diN+7-\u001e:fIJ+7o\\;sG\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001a-\t\tB)\u001a9m_f4\u0017\u000e\\3TKJ4\u0018nY3\t\u0011m\u0001!\u0011!Q\u0001\nq\t\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0006sKB|7/\u001b;pefL!!\t\u0010\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003M!W\r\u001d7ps\u001aLG.Z$f]\u0016\u0014\u0018\r^8s!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0004fqB|'\u000f\u001e\u0006\u0003S\u0019\t!\u0002Z3qY>Lh-\u001b7f\u0013\tYcEA\nEKBdw.\u001f4jY\u0016<UM\\3sCR|'\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003I!W\r\u001d7ps\u001aLG.Z#yK\u000e,Ho\u001c:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005EB\u0013aB3yK\u000e,H/Z\u0005\u0003gA\u0012!\u0003R3qY>Lh-\u001b7f\u000bb,7-\u001e;pe\"AQ\u0007\u0001B\u0001B\u0003%a'A\u000eeKBdw.\u001f4jY\u0016\u0014VMZ3sK:\u001cWMU3t_24XM\u001d\t\u0003_]J!\u0001\u000f\u0019\u00037\u0011+\u0007\u000f\\8zM&dWMU3gKJ,gnY3SKN|GN^3s\u0011!Q\u0004A!A!\u0002\u0013Y\u0014AD2p[6\fg\u000eZ\"sK\u0006$xN\u001d\t\u0003_qJ!!\u0010\u0019\u0003!\rK7i\\7nC:$7I]3bi>\u0014\b\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002\u001f\r|W.\\1oI\u0016CXmY;u_J\u0004\"aL!\n\u0005\t\u0003$aD\"p[6\fg\u000eZ#yK\u000e,Ho\u001c:\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000b\u0011B^1mS\u0012\fGo\u001c:\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015A\u0003<bY&$\u0017\r^5p]*\u0011!JB\u0001\bg\u0016\u0014h/[2f\u0013\tauIA\u0005WC2LG-\u0019;pe\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0002\u0002\u0015*T)V3v\u000b\u0017\t\u0003#\u0002i\u0011A\u0001\u0005\u000675\u0003\r\u0001\b\u0005\u0006G5\u0003\r\u0001\n\u0005\u0006[5\u0003\rA\f\u0005\u0006k5\u0003\rA\u000e\u0005\u0006u5\u0003\ra\u000f\u0005\u0006\u007f5\u0003\r\u0001\u0011\u0005\u0006\t6\u0003\r!\u0012\u0015\u0003\u001bj\u0003\"a\u00174\u000e\u0003qS!!\u00180\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002`A\u00069a-Y2u_JL(BA1c\u0003\u0015\u0011W-\u00198t\u0015\t\u0019G-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0017aA8sO&\u0011q\r\u0018\u0002\n\u0003V$xn^5sK\u0012DQ!\u001b\u0001\u0005\u0002)\f\u0001bZ3oKJ\fG/\u001a\u000b\u0003Wb\u0004\"\u0001\\;\u000f\u00055\u001c\bC\u00018r\u001b\u0005y'B\u00019\r\u0003\u0019a$o\\8u})\t!/A\u0003tG\u0006d\u0017-\u0003\u0002uc\u00061\u0001K]3eK\u001aL!A^<\u0003\rM#(/\u001b8h\u0015\t!\u0018\u000fC\u0003zQ\u0002\u0007!0A\u0004g_2$WM]:\u0011\tm\f\ta[\u0007\u0002y*\u0011QP`\u0001\u0005kRLGNC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAP\u0001\u0003MSN$\bbBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003\u0017\t\u0019\u0002\u0005\u0003\u0002\u000e\u0005=Q\"A9\n\u0007\u0005E\u0011O\u0001\u0003V]&$\bBB\u0015\u0002\u0006\u0001\u00071\u000eC\u0004\u0002\u0018\u0001!\t!!\u0007\u00021\rDWmY6D_:$\u0017\u000e^5p]>s\u0007\f\u001c3Ta\u0016\u001c7\u000f\u0006\u0004\u0002\f\u0005m\u0011Q\b\u0005\t\u0003;\t)\u00021\u0001\u0002 \u0005I1m\u001c8eSRLwN\u001c\t\t\u0003\u001b\t\t#!\n\u0002\f%\u0019\u00111E9\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA\u0014\u0003c\t)D\u0004\u0003\u0002*\u00055bb\u00018\u0002,%\t!/C\u0002\u00020E\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0004\u0005M\"bAA\u0018cB!\u0011qGA\u001d\u001b\u0005A\u0013bAA\u001eQ\tiA)\u001b:fGR|'/_*qK\u000eD\u0001\"a\u0010\u0002\u0016\u0001\u0007\u0011\u0011I\u0001\tq2$7\u000b]3dgB1\u0011qEA\u0019\u0003\u0007\u0002B!a\u000e\u0002F%\u0019\u0011q\t\u0015\u0003\u000facGm\u00159fG\"9\u00111\n\u0001\u0005\u0002\u00055\u0013!H2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8G_J$\u0015N]3di>\u0014\u0018.Z:\u0015\t\u0005-\u0011q\n\u0005\t\u0003#\nI\u00051\u0001\u0002&\u0005!A-\u001b:t\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n1d\u00195fG.\u0004VM]7jgNLwN\u001c$pe\u0012K'/Z2u_JLH\u0003BA\u0006\u00033B\u0001\"a\u0017\u0002T\u0001\u0007\u0011QG\u0001\u0004I&\u0014\bbBA0\u0001\u0011\u0005\u0011\u0011M\u0001\u001fG\",7m[*fGV\u0014\u0018\u000e^=QKJl\u0017n]:j_:4uN]+tKJ$B!a\u0003\u0002d!A\u0011\u0011KA/\u0001\u0004\t)\u0003C\u0004\u0002h\u0001!I!!\u001b\u0002\u0019\r\f7\u000f^!oI\u000eCWmY6\u0016\t\u0005-\u0014\u0011\u000f\u000b\u0007\u0003[\ny)a%\u0011\t\u0005=\u0014\u0011\u000f\u0007\u0001\t!\t\u0019(!\u001aC\u0002\u0005U$!\u0001+\u0012\t\u0005]\u0014Q\u0010\t\u0005\u0003\u001b\tI(C\u0002\u0002|E\u0014qAT8uQ&tw\r\u0005\u0003\u0002\u0000\u0005-UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0007U$WNC\u0002\u0018\u0003\u000fS1!!#\u0007\u0003\u0019\u0001H.^4j]&!\u0011QRAA\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\t\u0003#\u000b)\u00071\u0001\u0002~\u0005\u00111-\u001b\u0005\t\u0003+\u000b)\u00071\u0001\u0002\u0018\u0006)1\r\\1{uB)A.!'\u0002n%\u0019\u00111T<\u0003\u000b\rc\u0017m]:\t\u0019\u0005}\u0005\u0001%A\u0001\u0002\u0003%\t!!)\u00023A\u0014x\u000e^3di\u0016$Ge\u00195fG.\u0004VM]7jgNLwN\u001c\u000b\u0005\u0003G\u000b9\r\u0006\u0004\u0002\f\u0005\u0015\u0016\u0011\u0018\u0005\u000b\u0003O\u000bi*!AA\u0002\u0005%\u0016a\u0001=%cA!\u00111VA[\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016A\u00039fe6L7o]5p]*\u0019\u00111\u0017\u0004\u0002\u0011M,7-\u001e:jifLA!a.\u0002.\nQ\u0001+\u001a:nSN\u001c\u0018n\u001c8\t\u0015\u0005m\u0016QTA\u0001\u0002\u0004\ti,A\u0002yII\u0002B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0004\u0003\u0007t\u0018\u0001\u00027b]\u001eL1A^Aa\u0011%\t9+!(\u0002\u0002\u0003\u0007\u0001\u000bK\u0002\u0001\u0003\u0017\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0004\u0003#\u0014\u0017AC:uKJ,w\u000e^=qK&!\u0011Q[Ah\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class DeployfileResource
extends AbstractSecuredResource
implements DeployfileService {
    private final RepositoryService repositoryService;
    private final DeployfileGenerator deployfileGenerator;
    private final DeployfileExecutor deployfileExecutor;
    private final DeployfileReferenceResolver deployfileReferenceResolver;
    private final CiCommandCreator commandCreator;
    private final CommandExecutor commandExecutor;
    private final Validator validator;

    public /* synthetic */ void protected$checkPermission(DeployfileResource x$1, Permission x$12, String x$2) {
        x$1.checkPermission(x$12, x$2);
    }

    public String generate(java.util.List<String> folders) {
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(folders).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.protected$checkPermission(this, DeployitPermissions.GENERATE_DEPLOY_FILE, x$1);
            return BoxedUnit.UNIT;
        });
        List directories = ((TraversableOnce)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repositoryService.read(folders, 0, false)).map((Function1 & Serializable & scala.Serializable)x$2 -> this.castAndCheck((ConfigurationItem)x$2, (Class)Directory.class), Buffer$.MODULE$.canBuildFrom())).toList();
        return this.deployfileGenerator.generate((List<Directory>)directories);
    }

    public void apply(String deployfile) {
        List<XldSpec> xldSpecs = this.deployfileExecutor.execute(deployfile);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            this.checkPermissionForDirectories((List<DirectorySpec>)dirs);
            return BoxedUnit.UNIT;
        }, xldSpecs);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            this.checkSecurityPermissionForUser((List<DirectorySpec>)dirs);
            return BoxedUnit.UNIT;
        }, xldSpecs);
        List commands = (List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            $this.deployfileReferenceResolver.resolveAll((XldSpec)spec);
            return $this.commandCreator.create((XldSpec)spec);
        }, List$.MODULE$.canBuildFrom());
        this.validator.validateCis(new ArrayList(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)commands.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            DeployfileCommand deployfileCommand = x0$1;
            if (deployfileCommand instanceof DeleteCiCommand) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (deployfileCommand instanceof CiCommand) {
                CiCommand ciCommand = (CiCommand)deployfileCommand;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ciCommand.ci()));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom()))));
        this.commandExecutor.execute((List<DeployfileCommand>)commands);
    }

    public void checkConditionOnXldSpecs(Function1<List<DirectorySpec>, BoxedUnit> condition, List<XldSpec> xldSpecs) {
        ((List)((List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(x$3.getScopes()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getForDirectories(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)dirs -> {
            DeployfileResource.$anonfun$checkConditionOnXldSpecs$3(condition, dirs);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectories(List<DirectorySpec> dirs) {
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkPermissionForDirectory(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectory(DirectorySpec dir) {
        block0: {
            if (dir.getId() == null) break block0;
            String idToCheck = this.repositoryService.exists(dir.getId()) ? dir.getId() : JcrPathHelper.getParentId((String)dir.getId());
            this.checkPermission(PlatformPermissions.EDIT_REPO, idToCheck);
        }
    }

    public void checkSecurityPermissionForUser(List<DirectorySpec> dirs) {
        block0: {
            if (!((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPermissions(), List$.MODULE$.canBuildFrom())).nonEmpty()) break block0;
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        }
    }

    private <T extends ConfigurationItem> T castAndCheck(ConfigurationItem ci, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci));
    }

    public static final /* synthetic */ void $anonfun$checkConditionOnXldSpecs$3(Function1 condition$1, ForDirectories dirs) {
        List list = Option$.MODULE$.apply((Object)dirs.getForEnvironments()).toList();
        List specs = Option$.MODULE$.apply((Object)dirs.getForInfrastructure()).toList().$colon$colon$colon(list);
        condition$1.apply((Object)specs);
    }

    @Autowired
    public DeployfileResource(RepositoryService repositoryService, DeployfileGenerator deployfileGenerator, DeployfileExecutor deployfileExecutor, DeployfileReferenceResolver deployfileReferenceResolver, CiCommandCreator commandCreator, CommandExecutor commandExecutor, Validator validator) {
        this.repositoryService = repositoryService;
        this.deployfileGenerator = deployfileGenerator;
        this.deployfileExecutor = deployfileExecutor;
        this.deployfileReferenceResolver = deployfileReferenceResolver;
        this.commandCreator = commandCreator;
        this.commandExecutor = commandExecutor;
        this.validator = validator;
    }
}

