package com.xebialabs.ascode.yaml.parser.util

import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.parser.support.ReaderConfig

import scala.collection.convert.ImplicitConversions._
import com.xebialabs.ascode.utils.TypeSugar._

trait FieldBlacklisting {

  protected val prohibitedProperties: Map[String, List[String]]

  def validateJsonNode(node: JsonNode, config: ReaderConfig, ciType: Option[String]): Unit = {
    ciType.foreach { nodeType =>
      val fields = node.fieldNames()
      val notAllowedFields = fields.filter { field =>
        if (field != "type") isNotAllowed(updateFieldName(field, config), nodeType) else false
      }.toList

      if (notAllowedFields.nonEmpty) {
        throw new AsCodeException(s"The following fields are not allowed: ${notAllowedFields.mkString(", ")}")
      }
    }
  }

  private def updateFieldName(fieldName: String, config: ReaderConfig): String = {
    config.overrides.getOrElse(fieldName, fieldName)
  }

  protected def isNotAllowed(fieldName: String, nodeType: String): Boolean = {
    val isAnIgnoredProperty = prohibitedProperties.get(nodeType).exists(_.contains(fieldName))
    val propertyDescriptor = Option(typeOf(nodeType).getDescriptor.getPropertyDescriptor(fieldName))
    val isInternal = propertyDescriptor.exists(_.getCategory == "internal")
    val isHidden = propertyDescriptor.exists(_.isHidden)

    isAnIgnoredProperty || isInternal || isHidden
  }
}
