package com.xebialabs.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.overthere.OverthereFile

case class GenerateContext(additionalFile: List[AdditionalFile] = Nil, secrets: Map[String, String] = Map())
case class AdditionalFile(name: String, file: OverthereFile)

trait SpecWriter {
  def validate(spec: Spec)(implicit config: WriterConfig): Unit = {}
  def write(spec: Spec, yamlGenerator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext
}
