package com.xebialabs.deployit.core.rest

import java.io.OutputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type

import javax.ws.rs.Produces
import javax.ws.rs.core.{MediaType, MultivaluedMap}
import javax.ws.rs.ext.{MessageBodyWriter, Provider}
import org.springframework.stereotype.Component
import scala.collection.immutable.ListMap

@Component
@Provider
@Produces(Array("application/json"))
class ListMapMessageBodyWriter extends MessageBodyWriter[ListMap[Any, Any]] with JsonSupport {
  override def isWriteable(`type`: Class[_],
                           genericType: Type,
                           annotations: Array[Annotation],
                           mediaType: MediaType): Boolean = classOf[ListMap[Any, Any]].isAssignableFrom(`type`)

  override def writeTo(t: ListMap[Any, Any],
                       `type`: Class[_],
                       genericType: Type,
                       annotations: Array[Annotation],
                       mediaType: MediaType,
                       httpHeaders: MultivaluedMap[String, AnyRef],
                       entityStream: OutputStream): Unit = jsonMapper.writeValue(entityStream, t)
}
