package com.xebialabs.ascode.yaml.writer

import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator
import com.xebialabs.ascode.yaml.model.{Spec, User, UsersSpec}
import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.ascode.yaml.writer.support.SecretsIdUtils
import com.xebialabs.deployit.core.rest.YamlSupport._

class UsersWriter[T <: User](writeFields: (T, YAMLGenerator) => Unit = (_: T, _: YAMLGenerator) => {}) extends SpecWriter {
  override def write(spec: Spec, generator: YAMLGenerator)(implicit mapper: ObjectMapper, config: WriterConfig): GenerateContext = {
    val usersSpec = spec.asInstanceOf[UsersSpec]
    generator.writeStartArray()
    usersSpec.users.map(_.asInstanceOf[T]).foldLeft(Set[String]()) { (uniqueKeys, user) =>
      val uniqueKey = SecretsIdUtils.buildUniqueKey(s"user_${user.username}_password", uniqueKeys.contains)
      generator.writeStartObject()
      generator.writeStringField("username", user.username)
      generator.writeTaggedStringField("password", "value", uniqueKey)
      writeFields(user, generator)
      generator.writeEndObject()
      uniqueKeys + uniqueKey
    }
    generator.writeEndArray()
    GenerateContext()
  }
}
