package com.xebialabs.ascode.yaml

import com.xebialabs.ascode.exception.AsCodeException

case class Specs[T](specs: Map[(String, String), T]) {
  def getSpec(product: String, kind: String): T = {
    specs.get(product -> kind) match {
      case Some(generator) => generator
      case None =>
        val availableKinds = specs
          .keys
          .map { case (_, kinds) => kinds }
          .mkString("[", ", ", "]")

        val availableProducts = specs
          .keys
          .map { case (prod, _) => prod }
          .toList
          .distinct
          .mkString("[", ", ", "]")

        AsCodeException.throwDocumentFieldException(
          "kind",
          s"Unknown product and kind combination: product: [$product] kind: [$kind]. For this product use: $availableProducts. For kind use one of: $availableKinds"
        )
    }
  }
}
