package com.xebialabs.deployit.ascode.service.validation

import com.xebialabs.deployit.core.rest.api.InvalidDeploymentException
import com.xebialabs.deployit.engine.api.DeploymentService
import com.xebialabs.deployit.engine.api.dto.Deployment
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.stream.Collectors
import scala.jdk.CollectionConverters._

@Service
@Autowired
class DeploymentValidator(deploymentService: DeploymentService) {
  def validate(deployment: Deployment): Deployment = {
    try {
      deploymentService.validate(deployment)
    }
    catch {
      case ex: InvalidDeploymentException =>
        val deployeds = ex.getEntity.asInstanceOf[Deployment].getDeployeds
        val result = deployeds.stream().flatMap(item => item.get$validationMessages().asScala.map(vm => {vm.getMessage + Option(vm.getPropertyName).map(" for " + _).getOrElse("")}).asJava.stream()).collect(Collectors.joining("\n"))
        throw new InvalidDeploymentException("The Deployed Application contains the following validation errors\n" + result)
    }
  }
}