package com.xebialabs.deployit.ascode.service.validation

import com.xebialabs.ascode.exception.CiPermissionException
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.PermissionError
import com.xebialabs.deployit.repository.sql.CiRepository
import com.xebialabs.deployit.security.permission.Permission
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import com.xebialabs.ascode.utils.Utils._

@Service
@Autowired
class PermissionValidator(ciRepository: CiRepository) {
  private def hasPermission(permission: Permission, ciId: String): Boolean = {
    !ciId.parent.exists(ciRepository.exists) || permission.getPermissionHandler.hasPermission(ciId)
  }

  def checkPermissions(permission: Permission, ciIds: List[String]): Unit = {
    val errors = ciIds
      .filterNot(hasPermission(permission, _))
      .map(ciId => PermissionError(ciId, permission.getPermissionName))

    if (errors.nonEmpty) {
      throw CiPermissionException(errors)
    }
  }
}
