package com.xebialabs.deployit.ascode.yaml.model.permission

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.yaml.model.permission.{PermissionRelation, RolePermissionsRelation}
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._

import scala.jdk.CollectionConverters._

object DirectoryPermissionsRelation {
  def parse(node: JsonNode): DirectoryPermissionsRelation = {
    val directory = node.requiredString("directory")
    val roles = node
      .property("roles")
      .toList
      .flatMap(rolesNode => rolesNode.elements().asScala.map(RolePermissionsRelation.parse))
    DirectoryPermissionsRelation(directory, roles)
  }
}

case class DirectoryPermissionsRelation(directory: String,
                                        @JsonInclude(Include.NON_EMPTY) roles: List[RolePermissionsRelation]) extends PermissionRelation
