/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest;

import com.xebialabs.ascode.service.spec.InterpreterContext;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.writer.DefinitionWriter;
import com.xebialabs.deployit.ascode.service.DefinitionInterpreterService;
import com.xebialabs.deployit.ascode.service.generator.DefinitionGeneratorService;
import com.xebialabs.deployit.ascode.yaml.parser.XLDDefinitionParser;
import com.xebialabs.deployit.ascode.yaml.sugar.XLDSugar;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.engine.api.XLDAsCodeService;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Option;
import scala.collection.immutable.List;

@Controller
public class XLDAsCodeServiceImpl
implements XLDAsCodeService {
    private static final String AS_CODE_APPLY_PREFIX = "as-code-apply";
    private static final String AS_CODE_GENERATE_PREFIX = "as-code-generate";
    private static final Logger logger = LoggerFactory.getLogger(XLDAsCodeServiceImpl.class);
    private final DefinitionInterpreterService asCodeInterpretationService;
    private final DefinitionGeneratorService generatorService;
    private final XLDDefinitionParser parser;

    @Autowired
    public XLDAsCodeServiceImpl(DefinitionInterpreterService asCodeInterpretationService, DefinitionGeneratorService generatorService, XLDDefinitionParser parser) {
        this.asCodeInterpretationService = asCodeInterpretationService;
        this.generatorService = generatorService;
        this.parser = parser;
        logger.debug("XLDAsCodeServiceImpl bean created successfully");
    }

    @Workdir(prefix="as-code-apply", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    public XLDAsCodeResult apply(String yamlContent) {
        logger.debug("XLDAsCodeServiceImpl.apply() called with YAML content length: {}", (Object)(yamlContent != null ? yamlContent.length() : 0));
        try {
            String currentUser = System.getProperty("user.name");
            String javaVersion = System.getProperty("java.version");
            String processId = String.valueOf(ProcessHandle.current().pid());
            String workingDir = System.getProperty("user.dir");
            logger.info("=== MASTER NODE EXECUTION INFO ===");
            logger.info("XLDAsCodeServiceImpl.apply() - User: {}, PID: {}, Java: {}", new Object[]{currentUser, processId, javaVersion});
            logger.info("Working Directory: {}", (Object)workingDir);
            logger.info("Thread: {}", (Object)Thread.currentThread().getName());
            logger.info("==================================");
        }
        catch (Exception e) {
            logger.warn("Could not retrieve master node execution info: {}", (Object)e.getMessage());
        }
        logger.debug("Applying DevOps-as-Code YAML via XLDAsCodeService");
        try {
            Definition definition = this.parseYamlContent(yamlContent);
            AsCodeResponse response = this.asCodeInterpretationService.interpret(new InterpreterContext(definition, Option.empty()));
            logger.debug("DevOps-as-Code apply successful");
            if (response != null && logger.isDebugEnabled()) {
                if (response.changes().isDefined()) {
                    AsCodeResponse.Changes changes = (AsCodeResponse.Changes)response.changes().get();
                    logger.debug("Changes detected: {}", (Object)changes);
                } else {
                    logger.debug("No changes detected in response");
                }
                if (response.errors().isDefined()) {
                    logger.warn("Errors in response: {}", response.errors().get());
                }
            }
            return new XLDAsCodeResult(true, "DevOps-as-Code YAML applied successfully", response != null ? response.toString() : "null response", null);
        }
        catch (Exception e) {
            logger.error("Failed to apply DevOps-as-Code YAML: {}", (Object)e.getMessage(), (Object)e);
            return new XLDAsCodeResult(false, "Failed to apply YAML: " + e.getMessage(), null, this.getStackTrace(e));
        }
    }

    @Workdir(prefix="as-code-generate", clean=Workdir.Clean.ONLY_ON_EXCEPTION)
    public XLDAsCodeResult generate(String path, boolean globalPermissions, boolean roles, boolean users, boolean includeSecrets, boolean includeDefaults) {
        logger.debug("Generating DevOps-as-Code YAML via XLDAsCodeService for path: {}", (Object)path);
        try {
            DefinitionGeneratorService.GeneratorConfig config = new DefinitionGeneratorService.GeneratorConfig((Option<String>)Option.apply((Object)path).filter(p -> p != null && !p.isEmpty()), globalPermissions, roles, users, includeSecrets);
            List<Definition> definitions = this.generatorService.generate(config);
            DefinitionWriter.WriterConfig writerConfig = new DefinitionWriter.WriterConfig(definitions, includeSecrets, includeDefaults);
            logger.debug("DevOps-as-Code generation successful");
            String generatedContent = writerConfig.toString();
            return new XLDAsCodeResult(true, "DevOps-as-Code YAML generated successfully", generatedContent, null);
        }
        catch (Exception e) {
            logger.error("Failed to generate DevOps-as-Code YAML: {}", (Object)e.getMessage(), (Object)e);
            return new XLDAsCodeResult(false, "Failed to generate YAML: " + e.getMessage(), null, this.getStackTrace(e));
        }
    }

    private Definition parseYamlContent(String yamlContent) {
        try {
            return this.parser.parse(new ByteArrayInputStream(yamlContent.getBytes()), XLDSugar.defaultConfig());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse YAML content: " + e.getMessage(), e);
        }
    }

    private String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

