package com.xebialabs.deployit.core.rest.support

import java.io.InputStream
import java.lang.annotation.Annotation
import java.lang.reflect.Type

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.deployit.ascode.yaml.parser.XLDDefinitionParser
import jakarta.ws.rs.Consumes
import jakarta.ws.rs.core.{MediaType, MultivaluedMap}
import jakarta.ws.rs.ext.{MessageBodyReader, Provider}
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import com.xebialabs.deployit.ascode.yaml.sugar.XLDSugar.defaultConfig

@Component
@Provider
@Consumes(Array("text/vnd.yaml"))
@Autowired
class DefinitionMessageBodyReader(parser: XLDDefinitionParser) extends MessageBodyReader[Definition] {
  override def isReadable(`type`: Class[_],
                          genericType: Type,
                          annotations: Array[Annotation],
                          mediaType: MediaType): Boolean = classOf[Definition].isAssignableFrom(`type`)

  override def readFrom(`type`: Class[Definition],
                        genericType: Type,
                        annotations: Array[Annotation],
                        mediaType: MediaType,
                        httpHeaders: MultivaluedMap[String, String],
                        entityStream: InputStream): Definition =
    AsCodeException.wrapUnhandled(parser.parse(entityStream))
}
